/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound.hyphenation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.analysis.compound.hyphenation.Hyphen;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationException;
import org.apache.lucene.analysis.compound.hyphenation.PatternConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternParser
extends DefaultHandler
implements PatternConsumer {
    XMLReader parser;
    int currElement;
    PatternConsumer consumer;
    StringBuilder token = new StringBuilder();
    ArrayList<Object> exception;
    char hyphenChar;
    String errMsg;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;

    public PatternParser() throws HyphenationException {
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.parser.setEntityResolver(this);
        this.hyphenChar = (char)45;
    }

    public PatternParser(PatternConsumer consumer) throws HyphenationException {
        this();
        this.consumer = consumer;
    }

    public void setConsumer(PatternConsumer consumer) {
        this.consumer = consumer;
    }

    public void parse(String filename2) throws HyphenationException {
        this.parse(new InputSource(filename2));
    }

    public void parse(File file2) throws HyphenationException {
        try {
            InputSource src = new InputSource(file2.toURL().toExternalForm());
            this.parse(src);
        }
        catch (MalformedURLException e) {
            throw new HyphenationException("Error converting the File '" + file2 + "' to a URL: " + e.getMessage());
        }
    }

    public void parse(InputSource source2) throws HyphenationException {
        try {
            this.parser.parse(source2);
        }
        catch (FileNotFoundException fnfe) {
            throw new HyphenationException("File not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new HyphenationException(ioe.getMessage());
        }
        catch (SAXException e) {
            throw new HyphenationException(this.errMsg);
        }
    }

    static XMLReader createParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create XMLReader: " + e.getMessage());
        }
    }

    protected String readToken(StringBuffer chars2) {
        int countr;
        int i2;
        boolean space = false;
        for (i2 = 0; i2 < chars2.length() && Character.isWhitespace(chars2.charAt(i2)); ++i2) {
            space = true;
        }
        if (space) {
            for (countr = i2; countr < chars2.length(); ++countr) {
                chars2.setCharAt(countr - i2, chars2.charAt(countr));
            }
            chars2.setLength(chars2.length() - i2);
            if (this.token.length() > 0) {
                String word = this.token.toString();
                this.token.setLength(0);
                return word;
            }
        }
        space = false;
        for (i2 = 0; i2 < chars2.length(); ++i2) {
            if (!Character.isWhitespace(chars2.charAt(i2))) continue;
            space = true;
            break;
        }
        this.token.append(chars2.toString().substring(0, i2));
        for (countr = i2; countr < chars2.length(); ++countr) {
            chars2.setCharAt(countr - i2, chars2.charAt(countr));
        }
        chars2.setLength(chars2.length() - i2);
        if (space) {
            String word = this.token.toString();
            this.token.setLength(0);
            return word;
        }
        this.token.append(chars2);
        return null;
    }

    protected static String getPattern(String word) {
        StringBuilder pat = new StringBuilder();
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isDigit(word.charAt(i2))) continue;
            pat.append(word.charAt(i2));
        }
        return pat.toString();
    }

    protected ArrayList<Object> normalizeException(ArrayList<?> ex) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i2 = 0; i2 < ex.size(); ++i2) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                String str = (String)item;
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < str.length(); ++j) {
                    char c = str.charAt(j);
                    if (c != this.hyphenChar) {
                        buf.append(c);
                        continue;
                    }
                    res.add(buf.toString());
                    buf.setLength(0);
                    char[] h = new char[]{this.hyphenChar};
                    res.add(new Hyphen(new String(h), null, null));
                }
                if (buf.length() <= 0) continue;
                res.add(buf.toString());
                continue;
            }
            res.add(item);
        }
        return res;
    }

    protected String getExceptionWord(ArrayList<?> ex) {
        StringBuilder res = new StringBuilder();
        for (int i2 = 0; i2 < ex.size(); ++i2) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                res.append((String)item);
                continue;
            }
            if (((Hyphen)item).noBreak == null) continue;
            res.append(((Hyphen)item).noBreak);
        }
        return res.toString();
    }

    protected static String getInterletterValues(String pat) {
        StringBuilder il = new StringBuilder();
        String word = pat + "a";
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = word.charAt(i2);
            if (Character.isDigit(c)) {
                il.append(c);
                ++i2;
                continue;
            }
            il.append('0');
        }
        return il.toString();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.matches("(?i).*\\bhyphenation.dtd\\b.*") || "hyphenation-info".equals(publicId)) {
            return new InputSource(this.getClass().getResource("hyphenation.dtd").toExternalForm());
        }
        return null;
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) {
        if (local.equals("hyphen-char")) {
            String h = attrs.getValue("value");
            if (h != null && h.length() == 1) {
                this.hyphenChar = h.charAt(0);
            }
        } else if (local.equals("classes")) {
            this.currElement = 1;
        } else if (local.equals("patterns")) {
            this.currElement = 3;
        } else if (local.equals("exceptions")) {
            this.currElement = 2;
            this.exception = new ArrayList();
        } else if (local.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.add(this.token.toString());
            }
            this.exception.add(new Hyphen(attrs.getValue("pre"), attrs.getValue("no"), attrs.getValue("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        if (this.token.length() > 0) {
            String word = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(word), PatternParser.getInterletterValues(word));
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    @Override
    public void characters(char[] ch, int start2, int length2) {
        StringBuffer chars2 = new StringBuffer(length2);
        chars2.append(ch, start2, length2);
        String word = this.readToken(chars2);
        while (word != null) {
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(word), PatternParser.getInterletterValues(word));
                }
            }
            word = this.readToken(chars2);
        }
    }

    private String getLocationString(SAXParseException ex) {
        StringBuilder str = new StringBuilder();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index2 = systemId.lastIndexOf(47);
            if (index2 != -1) {
                systemId = systemId.substring(index2 + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    @Override
    public void addClass(String c) {
        System.out.println("class: " + c);
    }

    @Override
    public void addException(String w, ArrayList<Object> e) {
        System.out.println("exception: " + w + " : " + e.toString());
    }

    @Override
    public void addPattern(String p2, String v) {
        System.out.println("pattern: " + p2 + " : " + v);
    }

    public static void main(String[] args2) throws Exception {
        if (args2.length > 0) {
            PatternParser pp = new PatternParser();
            pp.setConsumer(pp);
            pp.parse(args2[0]);
        }
    }
}

