/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;

public final class LimitTokenCountAnalyzer
extends Analyzer {
    private final Analyzer delegate;
    private final int maxTokenCount;

    public LimitTokenCountAnalyzer(Analyzer delegate2, int maxTokenCount) {
        this.delegate = delegate2;
        this.maxTokenCount = maxTokenCount;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new LimitTokenCountFilter(this.delegate.tokenStream(fieldName, reader), this.maxTokenCount);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return new LimitTokenCountFilter(this.delegate.reusableTokenStream(fieldName, reader), this.maxTokenCount);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.delegate.getPositionIncrementGap(fieldName);
    }

    public int getOffsetGap(Fieldable field2) {
        return this.delegate.getOffsetGap(field2);
    }

    public String toString() {
        return "LimitTokenCountAnalyzer(" + this.delegate.toString() + ", maxTokenCount=" + this.maxTokenCount + ")";
    }
}

