/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.jmx;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public abstract class AbstractDynamicMBean
implements DynamicMBean,
MBeanRegistration {
    String dClassName;
    MBeanServer server;
    private final Vector mbeanList = new Vector();

    protected static String getAppenderName(Appender appender) {
        String name2 = appender.getName();
        if (name2 == null || name2.trim().length() == 0) {
            name2 = appender.toString();
        }
        return name2;
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i2 = 0; i2 < attributeNames.length; ++i2) {
            try {
                Object value2 = this.getAttribute(attributeNames[i2]);
                resultList.add(new Attribute(attributeNames[i2], value2));
                continue;
            }
            catch (JMException e) {
                e.printStackTrace();
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList attributes cannot be null"), "Cannot invoke a setter of " + this.dClassName);
        }
        AttributeList resultList = new AttributeList();
        if (attributes.isEmpty()) {
            return resultList;
        }
        Iterator i2 = attributes.iterator();
        while (i2.hasNext()) {
            Attribute attr2 = (Attribute)i2.next();
            try {
                this.setAttribute(attr2);
                String name2 = attr2.getName();
                Object value2 = this.getAttribute(name2);
                resultList.add(new Attribute(name2, value2));
            }
            catch (JMException e) {
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        return resultList;
    }

    protected abstract Logger getLogger();

    public void postDeregister() {
        this.getLogger().debug("postDeregister is called.");
    }

    public void postRegister(Boolean registrationDone) {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name2) {
        this.getLogger().debug("preRegister called. Server=" + server + ", name=" + name2);
        this.server = server;
        return name2;
    }

    protected void registerMBean(Object mbean, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.server.registerMBean(mbean, objectName);
        this.mbeanList.add(objectName);
    }

    public void preDeregister() {
        this.getLogger().debug("preDeregister called.");
        Enumeration iterator = this.mbeanList.elements();
        while (iterator.hasMoreElements()) {
            ObjectName name2 = (ObjectName)iterator.nextElement();
            try {
                this.server.unregisterMBean(name2);
            }
            catch (InstanceNotFoundException e) {
                this.getLogger().warn("Missing MBean " + name2.getCanonicalName());
            }
            catch (MBeanRegistrationException e) {
                this.getLogger().warn("Failed unregistering " + name2.getCanonicalName());
            }
        }
    }
}

