/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UriPatternMatcher {
    private final Map map = new HashMap();

    public synchronized void register(String pattern, Object obj) {
        if (pattern == null) {
            throw new IllegalArgumentException("URI request pattern may not be null");
        }
        this.map.put(pattern, obj);
    }

    public synchronized void unregister(String pattern) {
        if (pattern == null) {
            return;
        }
        this.map.remove(pattern);
    }

    public synchronized void setHandlers(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.map.clear();
        this.map.putAll(map);
    }

    public synchronized void setObjects(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map of handlers may not be null");
        }
        this.map.clear();
        this.map.putAll(map);
    }

    public synchronized Object lookup(String requestURI) {
        Object obj;
        if (requestURI == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        int index2 = requestURI.indexOf("?");
        if (index2 != -1) {
            requestURI = requestURI.substring(0, index2);
        }
        if ((obj = this.map.get(requestURI)) == null) {
            String bestMatch = null;
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                String pattern = (String)it.next();
                if (!this.matchUriRequestPattern(pattern, requestURI) || bestMatch != null && bestMatch.length() >= pattern.length() && (bestMatch.length() != pattern.length() || !pattern.endsWith("*"))) continue;
                obj = this.map.get(pattern);
                bestMatch = pattern;
            }
        }
        return obj;
    }

    protected boolean matchUriRequestPattern(String pattern, String requestUri) {
        if (pattern.equals("*")) {
            return true;
        }
        return pattern.endsWith("*") && requestUri.startsWith(pattern.substring(0, pattern.length() - 1)) || pattern.startsWith("*") && requestUri.endsWith(pattern.substring(1, pattern.length()));
    }
}

