/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static final String formatElements(HeaderElement[] elems, boolean quote2, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatElements(null, elems, quote2).toString();
    }

    public CharArrayBuffer formatElements(CharArrayBuffer buffer, HeaderElement[] elems, boolean quote2) {
        if (elems == null) {
            throw new IllegalArgumentException("Header element array must not be null.");
        }
        int len = this.estimateElementsLen(elems);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i2 = 0; i2 < elems.length; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            this.formatHeaderElement(buffer, elems[i2], quote2);
        }
        return buffer;
    }

    protected int estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result2 = (elems.length - 1) * 2;
        for (int i2 = 0; i2 < elems.length; ++i2) {
            result2 += this.estimateHeaderElementLen(elems[i2]);
        }
        return result2;
    }

    public static final String formatHeaderElement(HeaderElement elem, boolean quote2, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatHeaderElement(null, elem, quote2).toString();
    }

    public CharArrayBuffer formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem, boolean quote2) {
        int parcnt;
        if (elem == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int len = this.estimateHeaderElementLen(elem);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(elem.getName());
        String value2 = elem.getValue();
        if (value2 != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value2, quote2);
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < parcnt; ++i2) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i2), quote2);
            }
        }
        return buffer;
    }

    protected int estimateHeaderElementLen(HeaderElement elem) {
        int parcnt;
        if (elem == null) {
            return 0;
        }
        int result2 = elem.getName().length();
        String value2 = elem.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i2 = 0; i2 < parcnt; ++i2) {
                result2 += 2 + this.estimateNameValuePairLen(elem.getParameter(i2));
            }
        }
        return result2;
    }

    public static final String formatParameters(NameValuePair[] nvps, boolean quote2, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatParameters(null, nvps, quote2).toString();
    }

    public CharArrayBuffer formatParameters(CharArrayBuffer buffer, NameValuePair[] nvps, boolean quote2) {
        if (nvps == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        int len = this.estimateParametersLen(nvps);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i2 = 0; i2 < nvps.length; ++i2) {
            if (i2 > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i2], quote2);
        }
        return buffer;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result2 = (nvps.length - 1) * 2;
        for (int i2 = 0; i2 < nvps.length; ++i2) {
            result2 += this.estimateNameValuePairLen(nvps[i2]);
        }
        return result2;
    }

    public static final String formatNameValuePair(NameValuePair nvp, boolean quote2, HeaderValueFormatter formatter) {
        if (formatter == null) {
            formatter = DEFAULT;
        }
        return formatter.formatNameValuePair(null, nvp, quote2).toString();
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote2) {
        if (nvp == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int len = this.estimateNameValuePairLen(nvp);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value2 = nvp.getValue();
        if (value2 != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value2, quote2);
        }
        return buffer;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result2 = nvp.getName().length();
        String value2 = nvp.getValue();
        if (value2 != null) {
            result2 += 3 + value2.length();
        }
        return result2;
    }

    protected void doFormatValue(CharArrayBuffer buffer, String value2, boolean quote2) {
        int i2;
        if (!quote2) {
            for (i2 = 0; i2 < value2.length() && !quote2; ++i2) {
                quote2 = this.isSeparator(value2.charAt(i2));
            }
        }
        if (quote2) {
            buffer.append('\"');
        }
        for (i2 = 0; i2 < value2.length(); ++i2) {
            char ch = value2.charAt(i2);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (quote2) {
            buffer.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

