/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.entity;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.ParseException;
import org.apache.http.ProtocolException;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.params.HttpParams;

public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public long determineLength(HttpMessage message2) throws HttpException {
        if (message2 == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        HttpParams params2 = message2.getParams();
        boolean strict = params2.isParameterTrue("http.protocol.strict-transfer-encoding");
        Header transferEncodingHeader = message2.getFirstHeader("Transfer-Encoding");
        Header contentLengthHeader = message2.getFirstHeader("Content-Length");
        if (transferEncodingHeader != null) {
            HeaderElement[] encodings = null;
            try {
                encodings = transferEncodingHeader.getElements();
            }
            catch (ParseException px) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + transferEncodingHeader, px);
            }
            if (strict) {
                for (int i2 = 0; i2 < encodings.length; ++i2) {
                    String encoding2 = encodings[i2].getName();
                    if (encoding2 == null || encoding2.length() <= 0 || encoding2.equalsIgnoreCase("chunked") || encoding2.equalsIgnoreCase("identity")) continue;
                    throw new ProtocolException("Unsupported transfer encoding: " + encoding2);
                }
            }
            int len = encodings.length;
            if ("identity".equalsIgnoreCase(transferEncodingHeader.getValue())) {
                return -1L;
            }
            if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                return -2L;
            }
            if (strict) {
                throw new ProtocolException("Chunk-encoding must be the last one applied");
            }
            return -1L;
        }
        if (contentLengthHeader != null) {
            long contentlen = -1L;
            Header[] headers = message2.getHeaders("Content-Length");
            if (strict && headers.length > 1) {
                throw new ProtocolException("Multiple content length headers");
            }
            for (int i3 = headers.length - 1; i3 >= 0; --i3) {
                Header header = headers[i3];
                try {
                    contentlen = Long.parseLong(header.getValue());
                    break;
                }
                catch (NumberFormatException e) {
                    if (!strict) continue;
                    throw new ProtocolException("Invalid content length: " + header.getValue());
                }
            }
            if (contentlen >= 0L) {
                return contentlen;
            }
            return -1L;
        }
        return -1L;
    }
}

