/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.cache.HttpCacheEntry;

@Immutable
class CacheKeyGenerator {
    CacheKeyGenerator() {
    }

    public String getURI(HttpHost host, HttpRequest req) {
        if (this.isRelativeRequest(req)) {
            return this.canonicalizeUri(String.format("%s%s", host.toString(), req.getRequestLine().getUri()));
        }
        return this.canonicalizeUri(req.getRequestLine().getUri());
    }

    public String canonicalizeUri(String uri) {
        try {
            String query;
            URL u = new URL(uri);
            String protocol2 = u.getProtocol().toLowerCase();
            String hostname = u.getHost().toLowerCase();
            int port = this.canonicalizePort(u.getPort(), protocol2);
            String path2 = this.canonicalizePath(u.getPath());
            if ("".equals(path2)) {
                path2 = "/";
            }
            String file2 = (query = u.getQuery()) != null ? path2 + "?" + query : path2;
            URL out = new URL(protocol2, hostname, port, file2);
            return out.toString();
        }
        catch (MalformedURLException e) {
            return uri;
        }
    }

    private String canonicalizePath(String path2) {
        try {
            String decoded = URLDecoder.decode(path2, "UTF-8");
            return new URI(decoded).getPath();
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return path2;
    }

    private int canonicalizePort(int port, String protocol2) {
        if (port == -1 && "http".equalsIgnoreCase(protocol2)) {
            return 80;
        }
        if (port == -1 && "https".equalsIgnoreCase(protocol2)) {
            return 443;
        }
        return port;
    }

    private boolean isRelativeRequest(HttpRequest req) {
        String requestUri = req.getRequestLine().getUri();
        return "*".equals(requestUri) || requestUri.startsWith("/");
    }

    protected String getFullHeaderValue(Header[] headers) {
        if (headers == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder("");
        boolean first2 = true;
        for (Header hdr : headers) {
            if (!first2) {
                buf.append(", ");
            }
            buf.append(hdr.getValue().trim());
            first2 = false;
        }
        return buf.toString();
    }

    public String getVariantURI(HttpHost host, HttpRequest req, HttpCacheEntry entry) {
        if (!entry.hasVariants()) {
            return this.getURI(host, req);
        }
        return this.getVariantKey(req, entry) + this.getURI(host, req);
    }

    public String getVariantKey(HttpRequest req, HttpCacheEntry entry) {
        StringBuilder buf;
        ArrayList<String> variantHeaderNames = new ArrayList<String>();
        for (Header varyHdr : entry.getHeaders("Vary")) {
            for (HeaderElement elt : varyHdr.getElements()) {
                variantHeaderNames.add(elt.getName());
            }
        }
        Collections.sort(variantHeaderNames);
        try {
            buf = new StringBuilder("{");
            boolean first2 = true;
            for (String headerName : variantHeaderNames) {
                if (!first2) {
                    buf.append("&");
                }
                buf.append(URLEncoder.encode(headerName, "UTF-8"));
                buf.append("=");
                buf.append(URLEncoder.encode(this.getFullHeaderValue(req.getHeaders(headerName)), "UTF-8"));
                first2 = false;
            }
            buf.append("}");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("couldn't encode to UTF-8", uee);
        }
        return buf.toString();
    }
}

