/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class CookieSpecRegistry {
    private final ConcurrentHashMap<String, CookieSpecFactory> registeredSpecs = new ConcurrentHashMap();

    public void register(String name2, CookieSpecFactory factory) {
        if (name2 == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Cookie spec factory may not be null");
        }
        this.registeredSpecs.put(name2.toLowerCase(Locale.ENGLISH), factory);
    }

    public void unregister(String id2) {
        if (id2 == null) {
            throw new IllegalArgumentException("Id may not be null");
        }
        this.registeredSpecs.remove(id2.toLowerCase(Locale.ENGLISH));
    }

    public CookieSpec getCookieSpec(String name2, HttpParams params2) throws IllegalStateException {
        if (name2 == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        CookieSpecFactory factory = this.registeredSpecs.get(name2.toLowerCase(Locale.ENGLISH));
        if (factory != null) {
            return factory.newInstance(params2);
        }
        throw new IllegalStateException("Unsupported cookie spec: " + name2);
    }

    public CookieSpec getCookieSpec(String name2) throws IllegalStateException {
        return this.getCookieSpec(name2, null);
    }

    public List<String> getSpecNames() {
        return new ArrayList<String>(this.registeredSpecs.keySet());
    }

    public void setItems(Map<String, CookieSpecFactory> map) {
        if (map == null) {
            return;
        }
        this.registeredSpecs.clear();
        this.registeredSpecs.putAll(map);
    }
}

