/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.digest;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public class DigestUtils {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    private static byte[] digest(MessageDigest digest2, InputStream data2) throws IOException {
        byte[] buffer = new byte[1024];
        int read2 = data2.read(buffer, 0, 1024);
        while (read2 > -1) {
            digest2.update(buffer, 0, read2);
            read2 = data2.read(buffer, 0, 1024);
        }
        return digest2.digest();
    }

    private static byte[] getBytesUtf8(String data2) {
        return StringUtils.getBytesUtf8(data2);
    }

    static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    private static MessageDigest getSha256Digest() {
        return DigestUtils.getDigest("SHA-256");
    }

    private static MessageDigest getSha384Digest() {
        return DigestUtils.getDigest("SHA-384");
    }

    private static MessageDigest getSha512Digest() {
        return DigestUtils.getDigest("SHA-512");
    }

    private static MessageDigest getShaDigest() {
        return DigestUtils.getDigest("SHA");
    }

    public static byte[] md5(byte[] data2) {
        return DigestUtils.getMd5Digest().digest(data2);
    }

    public static byte[] md5(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getMd5Digest(), data2);
    }

    public static byte[] md5(String data2) {
        return DigestUtils.md5(DigestUtils.getBytesUtf8(data2));
    }

    public static String md5Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    public static String md5Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    public static String md5Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.md5(data2));
    }

    public static byte[] sha(byte[] data2) {
        return DigestUtils.getShaDigest().digest(data2);
    }

    public static byte[] sha(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getShaDigest(), data2);
    }

    public static byte[] sha(String data2) {
        return DigestUtils.sha(DigestUtils.getBytesUtf8(data2));
    }

    public static byte[] sha256(byte[] data2) {
        return DigestUtils.getSha256Digest().digest(data2);
    }

    public static byte[] sha256(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha256Digest(), data2);
    }

    public static byte[] sha256(String data2) {
        return DigestUtils.sha256(DigestUtils.getBytesUtf8(data2));
    }

    public static String sha256Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static String sha256Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static String sha256Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha256(data2));
    }

    public static byte[] sha384(byte[] data2) {
        return DigestUtils.getSha384Digest().digest(data2);
    }

    public static byte[] sha384(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha384Digest(), data2);
    }

    public static byte[] sha384(String data2) {
        return DigestUtils.sha384(DigestUtils.getBytesUtf8(data2));
    }

    public static String sha384Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static String sha384Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static String sha384Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha384(data2));
    }

    public static byte[] sha512(byte[] data2) {
        return DigestUtils.getSha512Digest().digest(data2);
    }

    public static byte[] sha512(InputStream data2) throws IOException {
        return DigestUtils.digest(DigestUtils.getSha512Digest(), data2);
    }

    public static byte[] sha512(String data2) {
        return DigestUtils.sha512(DigestUtils.getBytesUtf8(data2));
    }

    public static String sha512Hex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    public static String sha512Hex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    public static String sha512Hex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha512(data2));
    }

    public static String shaHex(byte[] data2) {
        return Hex.encodeHexString(DigestUtils.sha(data2));
    }

    public static String shaHex(InputStream data2) throws IOException {
        return Hex.encodeHexString(DigestUtils.sha(data2));
    }

    public static String shaHex(String data2) {
        return Hex.encodeHexString(DigestUtils.sha(data2));
    }
}

