/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayDeque;
import java.util.LinkedList;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.XmlDeclHandler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class NokogiriHandler
extends DefaultHandler2
implements XmlDeclHandler {
    private StringBuffer buffer;
    private final Ruby ruby;
    private final RubyClass attrClass;
    private final IRubyObject object;
    private final LinkedList<XmlSyntaxError> errors = new LinkedList();
    private Locator locator;
    private final ArrayDeque<Integer> lines;
    private final ArrayDeque<Integer> columns;
    private static String htmlParserName = "Nokogiri::HTML::SAX::Parser";
    private boolean needEmptyAttrCheck = false;
    private static String[] emptyAttrs = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "noresize", "nohref", "noshade", "nowrap", "readonly", "selected"};

    public NokogiriHandler(Ruby ruby2, IRubyObject iRubyObject) {
        this.ruby = ruby2;
        this.attrClass = (RubyClass)ruby2.getClassFromPath("Nokogiri::XML::SAX::Parser::Attribute");
        this.object = iRubyObject;
        this.lines = new ArrayDeque();
        this.columns = new ArrayDeque();
        String string2 = iRubyObject.getMetaClass().getName();
        if (htmlParserName.equals(string2)) {
            this.needEmptyAttrCheck = true;
        }
    }

    public void skippedEntity(String string2) {
        this.call("error", this.ruby.newString("Entity '" + string2 + "' not defined\n"));
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        this.call("start_document");
    }

    public void xmlDecl(String string2, String string3, String string4) {
        this.call("xmldecl", NokogiriHelpers.stringOrNil(this.ruby, string2), NokogiriHelpers.stringOrNil(this.ruby, string3), NokogiriHelpers.stringOrNil(this.ruby, string4));
    }

    public void endDocument() throws SAXException {
        this.call("end_document");
    }

    public void processingInstruction(String string2, String string3) {
        this.call("processing_instruction", this.ruby.newString(string2), this.ruby.newString(string3));
    }

    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        RubyArray rubyArray = RubyArray.newArray(this.ruby);
        RubyArray rubyArray2 = RubyArray.newArray(this.ruby);
        ThreadContext threadContext = this.ruby.getCurrentContext();
        boolean bl = false;
        this.lines.add(this.locator.getLineNumber());
        this.columns.add(this.locator.getColumnNumber() - 1);
        for (int j = 0; j < attributes.getLength(); ++j) {
            IRubyObject[] iRubyObjectArray;
            String string5 = attributes.getURI(j);
            String string6 = attributes.getQName(j);
            String string7 = attributes.getLocalName(j);
            String string8 = attributes.getValue(j);
            String string9 = NokogiriHelpers.getPrefix(string6);
            if (string7 == null || string7.equals("")) {
                string7 = NokogiriHelpers.getLocalPart(string6);
            }
            if (NokogiriHelpers.isNamespace(string6) && !bl) {
                iRubyObjectArray = RubyArray.newArray(this.ruby, 2);
                if (string7.equals("xmlns")) {
                    string7 = null;
                }
                iRubyObjectArray.add(NokogiriHelpers.stringOrNil(this.ruby, string7));
                iRubyObjectArray.add(this.ruby.newString(string8));
                rubyArray2.add(iRubyObjectArray);
                continue;
            }
            iRubyObjectArray = null;
            if (this.needEmptyAttrCheck && this.isEmptyAttr(string7)) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(this.ruby, string7), NokogiriHelpers.stringOrNil(this.ruby, string9), NokogiriHelpers.stringOrNil(this.ruby, string5)};
            }
            if (iRubyObjectArray == null) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(this.ruby, string7), NokogiriHelpers.stringOrNil(this.ruby, string9), NokogiriHelpers.stringOrNil(this.ruby, string5), NokogiriHelpers.stringOrNil(this.ruby, string8)};
            }
            IRubyObject iRubyObject = RuntimeHelpers.invoke(threadContext, (IRubyObject)this.attrClass, "new", iRubyObjectArray);
            rubyArray.add(iRubyObject);
        }
        if (string3 == null || string3.equals("")) {
            string3 = NokogiriHelpers.getLocalPart(string4);
        }
        this.call("start_element_namespace", NokogiriHelpers.stringOrNil(this.ruby, string3), rubyArray, NokogiriHelpers.stringOrNil(this.ruby, NokogiriHelpers.getPrefix(string4)), NokogiriHelpers.stringOrNil(this.ruby, string2), rubyArray2);
    }

    private boolean isEmptyAttr(String string2) {
        for (String string3 : emptyAttrs) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public Integer getLine() {
        return this.lines.pop();
    }

    public Integer getColumn() {
        return this.columns.pop();
    }

    private boolean isFromFragmentHandler() {
        String string2;
        RubyObject rubyObject;
        IRubyObject iRubyObject;
        return this.object != null && this.object instanceof RubyObject && (iRubyObject = (rubyObject = (RubyObject)this.object).getInstanceVariable("@document")) != null && "Nokogiri::XML::FragmentHandler".equals(string2 = iRubyObject.getMetaClass().getName());
    }

    public void endElement(String string2, String string3, String string4) throws SAXException {
        this.call("end_element_namespace", NokogiriHelpers.stringOrNil(this.ruby, string3), NokogiriHelpers.stringOrNil(this.ruby, NokogiriHelpers.getPrefix(string4)), NokogiriHelpers.stringOrNil(this.ruby, string2));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(new String(cArray, n, n2));
        } else {
            this.call("characters", this.ruby.newString(new String(cArray, n, n2)));
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.call("comment", this.ruby.newString(new String(cArray, n, n2)));
    }

    public void startCDATA() throws SAXException {
        this.buffer = new StringBuffer();
    }

    public void endCDATA() throws SAXException {
        this.call("cdata_block", this.ruby.newString(this.buffer.toString()));
        this.buffer = null;
    }

    public void error(SAXParseException sAXParseException) {
        this.addError(XmlSyntaxError.createError(this.ruby, sAXParseException));
        this.call("error", this.ruby.newString(sAXParseException.getMessage()));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError(XmlSyntaxError.createFatalError(this.ruby, sAXParseException));
        this.call("error", this.ruby.newString(sAXParseException.getMessage()));
    }

    public void warning(SAXParseException sAXParseException) {
        this.call("warning", this.ruby.newString(sAXParseException.getMessage()));
    }

    protected synchronized void addError(XmlSyntaxError xmlSyntaxError) {
        this.errors.add(xmlSyntaxError);
    }

    public synchronized int getErrorCount() {
        return this.errors.size();
    }

    public synchronized IRubyObject getLastError() {
        return this.errors.getLast();
    }

    private void call(String string2) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke(threadContext, this.document(threadContext), string2);
    }

    private void call(String string2, IRubyObject iRubyObject) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke(threadContext, this.document(threadContext), string2, iRubyObject);
    }

    private void call(String string2, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke(threadContext, this.document(threadContext), string2, iRubyObject, iRubyObject2);
    }

    private void call(String string2, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke(threadContext, this.document(threadContext), string2, iRubyObject, iRubyObject2, iRubyObject3);
    }

    private void call(String string2, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5};
        ThreadContext threadContext = this.ruby.getCurrentContext();
        RuntimeHelpers.invoke(threadContext, this.document(threadContext), string2, iRubyObjectArray);
    }

    private IRubyObject document(ThreadContext threadContext) {
        if (this.object instanceof RubyObject) {
            return ((RubyObject)this.object).fastGetInstanceVariable("@document");
        }
        return threadContext.getRuntime().getNil();
    }
}

