/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriDomParser;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNonStrictErrorHandler4NekoHtml;
import nokogiri.internals.NokogiriStrictErrorHandler;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class HtmlDomParserContext
extends XmlDomParserContext {
    public HtmlDomParserContext(Ruby ruby2, IRubyObject iRubyObject) {
        super(ruby2, iRubyObject);
    }

    public HtmlDomParserContext(Ruby ruby2, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        super(ruby2, iRubyObject, iRubyObject2);
    }

    protected void initErrorHandler() {
        this.errorHandler = this.options.strict ? new NokogiriStrictErrorHandler(this.options.noError, this.options.noWarning) : new NokogiriNonStrictErrorHandler4NekoHtml(this.options.noError, this.options.noWarning);
    }

    protected void initParser(Ruby ruby2) {
        HTMLConfiguration hTMLConfiguration = new HTMLConfiguration();
        RemoveNSAttrsFilter removeNSAttrsFilter = new RemoveNSAttrsFilter();
        ElementValidityCheckFilter elementValidityCheckFilter = new ElementValidityCheckFilter(this.errorHandler);
        XMLDocumentFilter[] xMLDocumentFilterArray = new XMLDocumentFilter[]{elementValidityCheckFilter};
        hTMLConfiguration.setErrorHandler(this.errorHandler);
        this.parser = new NokogiriDomParser(hTMLConfiguration);
        this.setProperty("http://cyberneko.org/html/properties/default-encoding", this.java_encoding);
        this.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        this.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
        this.setProperty("http://cyberneko.org/html/properties/filters", xMLDocumentFilterArray);
        this.setFeature("http://cyberneko.org/html/features/report-errors", true);
        this.setFeature("http://xml.org/sax/features/namespaces", false);
    }

    public void enableDocumentFragment() {
        this.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
    }

    protected XmlDocument getNewEmptyDocument(ThreadContext threadContext) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[]{};
        return (XmlDocument)XmlDocument.rbNew(threadContext, NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"), iRubyObjectArray);
    }

    protected XmlDocument wrapDocument(ThreadContext threadContext, RubyClass rubyClass, Document document) {
        HtmlDocument htmlDocument = (HtmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), rubyClass);
        htmlDocument.setDocumentNode(threadContext, document);
        if (this.ruby_encoding.isNil()) {
            if (this.detected_encoding != null && !this.detected_encoding.isNil()) {
                this.ruby_encoding = this.detected_encoding;
            } else {
                String string2 = this.tryGetCharsetFromHtml5MetaTag(document);
                this.ruby_encoding = NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string2);
            }
        }
        htmlDocument.setEncoding(this.ruby_encoding);
        htmlDocument.setParsedEncoding(this.java_encoding);
        return htmlDocument;
    }

    private String tryGetCharsetFromHtml5MetaTag(Document document) {
        if (!"html".equalsIgnoreCase(document.getDocumentElement().getNodeName())) {
            return null;
        }
        NodeList nodeList = document.getDocumentElement().getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            if (!"head".equalsIgnoreCase(nodeList.item(j).getNodeName())) continue;
            NodeList nodeList2 = nodeList.item(j).getChildNodes();
            for (int k = 0; k < nodeList2.getLength(); ++k) {
                if (!"meta".equalsIgnoreCase(nodeList2.item(k).getNodeName())) continue;
                NamedNodeMap namedNodeMap = nodeList2.item(k).getAttributes();
                for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                    if (!"charset".equalsIgnoreCase(namedNodeMap.item(i2).getNodeName())) continue;
                    return namedNodeMap.item(i2).getNodeValue();
                }
            }
        }
        return null;
    }

    public static class ElementValidityCheckFilter
    extends DefaultFilter {
        private NokogiriErrorHandler errorHandler;
        private static String[][] element_names = new String[][]{{"a", "abbr", "acronym", "address", "area"}, {"b", "base", "basefont", "bdo", "big", "blockquote", "body", "br", "button"}, {"caption", "cite", "code", "col", "colgroup"}, {"dd", "del", "dfn", "div", "dl", "dt"}, {"em"}, {"fieldset", "font", "form", "frame", "frameset"}, new String[0], {"h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html"}, {"i", "iframe", "img", "input", "ins"}, new String[0], {"kbd"}, {"label", "legend", "li", "link"}, {"map", "meta"}, {"noframes", "noscript"}, {"object", "ol", "optgroup", "option"}, {"p", "param", "pre"}, {"q"}, new String[0], {"s", "samp", "script", "select", "small", "span", "strike", "strong", "style", "sub", "sup"}, {"table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "tt"}, {"u", "ul"}, {"var"}, new String[0], new String[0], new String[0], new String[0]};

        private ElementValidityCheckFilter(NokogiriErrorHandler nokogiriErrorHandler) {
            this.errorHandler = nokogiriErrorHandler;
        }

        private boolean isValid(String string2) {
            char[] cArray = string2.toCharArray();
            int n = new Integer(cArray[0]) - 97;
            if (n > 25) {
                return false;
            }
            for (int j = 0; j < element_names[n].length; ++j) {
                if (!string2.equals(element_names[n][j])) continue;
                return true;
            }
            return false;
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            if (!this.isValid(qName.rawname)) {
                this.errorHandler.getErrors().add(new Exception("Tag " + qName.rawname + " invalid"));
            }
            super.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public static class RemoveNSAttrsFilter
    extends DefaultFilter {
        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            for (int j = 0; j < xMLAttributes.getLength(); ++j) {
                if (!NokogiriHelpers.isNamespace(xMLAttributes.getQName(j))) continue;
                xMLAttributes.removeAttributeAt(j);
                --j;
            }
            qName.uri = null;
            super.startElement(qName, xMLAttributes, augmentations);
        }
    }
}

