/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriXsltErrorListener;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Nokogiri::XSLT::Stylesheet"})
public class XsltStylesheet
extends RubyObject {
    private static Map<String, Object> registry = new HashMap<String, Object>();
    private TransformerFactory factory = null;
    private Templates sheet = null;
    private IRubyObject stylesheet = null;
    private boolean htmlish = false;
    private Pattern p = Pattern.compile("'.{1,}'");
    private static Pattern html_tag = Pattern.compile("<(%s)*html", 2);

    public static Map<String, Object> getRegistry() {
        return registry;
    }

    public XsltStylesheet(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void addParametersToTransformer(ThreadContext threadContext, Transformer transformer, IRubyObject iRubyObject) {
        Ruby ruby2 = threadContext.getRuntime();
        if (iRubyObject instanceof RubyHash) {
            this.setHashParameters(transformer, (RubyHash)iRubyObject);
        } else if (iRubyObject instanceof RubyArray) {
            this.setArrayParameters(transformer, ruby2, (RubyArray)iRubyObject);
        } else {
            throw ruby2.newTypeError("parameters should be given either Array or Hash");
        }
    }

    private void setHashParameters(Transformer transformer, RubyHash rubyHash) {
        Set set = rubyHash.keySet();
        for (String string2 : set) {
            String string3 = (String)rubyHash.get(string2);
            transformer.setParameter(string2, this.unparseValue(string3));
        }
    }

    private void setArrayParameters(Transformer transformer, Ruby ruby2, RubyArray rubyArray) {
        int n = rubyArray.getLength();
        if (n % 2 == 1) {
            --n;
        }
        for (int j = 0; j < n; j += 2) {
            String string2 = rubyArray.aref(ruby2.newFixnum(j)).asJavaString();
            String string3 = rubyArray.aref(ruby2.newFixnum(j + 1)).asJavaString();
            transformer.setParameter(string2, this.unparseValue(string3));
        }
    }

    private String unparseValue(String string2) {
        Matcher matcher = this.p.matcher(string2);
        if (string2.startsWith("\"") && string2.endsWith("\"") || matcher.matches()) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        return string2;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject parse_stylesheet_doc(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby2 = threadContext.getRuntime();
        XsltStylesheet.ensureFirstArgIsDocument(ruby2, iRubyObjectArray[0]);
        XmlDocument xmlDocument = (XmlDocument)iRubyObjectArray[0];
        XsltStylesheet.ensureDocumentHasNoError(threadContext, xmlDocument);
        Document document = ((XmlDocument)xmlDocument.dup_implementation(threadContext, true)).getDocument();
        XsltStylesheet xsltStylesheet = (XsltStylesheet)NokogiriService.XSLT_STYLESHEET_ALLOCATOR.allocate(ruby2, (RubyClass)iRubyObject);
        try {
            xsltStylesheet.init(iRubyObjectArray[1], document);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw ruby2.newRuntimeError("could not parse xslt stylesheet");
        }
        return xsltStylesheet;
    }

    private void init(IRubyObject iRubyObject, Document document) throws TransformerConfigurationException {
        this.stylesheet = iRubyObject;
        if (this.factory == null) {
            this.factory = TransformerFactory.newInstance();
        }
        NokogiriXsltErrorListener nokogiriXsltErrorListener = new NokogiriXsltErrorListener();
        this.factory.setErrorListener(nokogiriXsltErrorListener);
        this.sheet = this.factory.newTemplates(new DOMSource(document));
    }

    private static void ensureFirstArgIsDocument(Ruby ruby2, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlDocument) {
            return;
        }
        throw ruby2.newArgumentError("doc must be a Nokogiri::XML::Document instance");
    }

    private static void ensureDocumentHasNoError(ThreadContext threadContext, XmlDocument xmlDocument) {
        Ruby ruby2 = threadContext.getRuntime();
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        if (!rubyArray.isEmpty()) {
            throw ruby2.newRuntimeError(rubyArray.first().asString().asJavaString());
        }
    }

    @JRubyMethod
    public IRubyObject serialize(ThreadContext threadContext, IRubyObject iRubyObject) {
        return RuntimeHelpers.invoke(threadContext, RuntimeHelpers.invoke(threadContext, iRubyObject, "root"), "to_s");
    }

    @JRubyMethod(rest=true, required=1, optional=2)
    public IRubyObject transform(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        Ruby ruby2 = threadContext.getRuntime();
        this.argumentTypeCheck(ruby2, iRubyObjectArray[0]);
        NokogiriXsltErrorListener nokogiriXsltErrorListener = new NokogiriXsltErrorListener();
        DOMSource dOMSource = new DOMSource(((XmlDocument)iRubyObjectArray[0]).getDocument());
        DOMResult dOMResult = null;
        String string2 = null;
        try {
            dOMResult = this.tryXsltTransformation(threadContext, iRubyObjectArray, dOMSource, nokogiriXsltErrorListener);
            if (dOMResult.getNode().getFirstChild() == null) {
                string2 = this.retryXsltTransformation(threadContext, iRubyObjectArray, dOMSource, nokogiriXsltErrorListener);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw ruby2.newRuntimeError(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw ruby2.newRuntimeError(transformerException.getMessage());
        }
        catch (IOException iOException) {
            throw ruby2.newRuntimeError(iOException.getMessage());
        }
        switch (nokogiriXsltErrorListener.getErrorType()) {
            case ERROR: 
            case FATAL: {
                throw ruby2.newRuntimeError(nokogiriXsltErrorListener.getErrorMessage());
            }
        }
        if (string2 == null) {
            return this.createDocumentFromDomResult(threadContext, ruby2, dOMResult);
        }
        return this.createDocumentFromString(threadContext, ruby2, string2);
    }

    private DOMResult tryXsltTransformation(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, DOMSource dOMSource, NokogiriXsltErrorListener nokogiriXsltErrorListener) throws TransformerException {
        Transformer transformer = this.sheet.newTransformer();
        transformer.reset();
        transformer.setErrorListener(nokogiriXsltErrorListener);
        if (iRubyObjectArray.length > 1) {
            this.addParametersToTransformer(threadContext, transformer, iRubyObjectArray[1]);
        }
        DOMResult dOMResult = new DOMResult();
        transformer.transform(dOMSource, dOMResult);
        return dOMResult;
    }

    private String retryXsltTransformation(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, DOMSource dOMSource, NokogiriXsltErrorListener nokogiriXsltErrorListener) throws TransformerException, IOException {
        Templates templates = this.getTemplatesFromStreamSource();
        Transformer transformer = templates.newTransformer();
        transformer.setErrorListener(nokogiriXsltErrorListener);
        if (iRubyObjectArray.length > 1) {
            this.addParametersToTransformer(threadContext, transformer, iRubyObjectArray[1]);
        }
        PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader();
        pipedWriter.connect(pipedReader);
        StreamResult streamResult = new StreamResult(pipedWriter);
        transformer.transform(dOMSource, streamResult);
        char[] cArray = new char[1024];
        int n = pipedReader.read(cArray, 0, 1024);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(CharBuffer.wrap(cArray, 0, n));
        this.htmlish = this.isHtml(stringBuilder.toString());
        while (n == 1024) {
            n = pipedReader.read(cArray, 0, 1024);
            if (n <= 0) continue;
            stringBuilder.append(CharBuffer.wrap(cArray, 0, n));
        }
        pipedReader.close();
        pipedWriter.close();
        return stringBuilder.toString();
    }

    private IRubyObject createDocumentFromDomResult(ThreadContext threadContext, Ruby ruby2, DOMResult dOMResult) {
        if ("html".equals(dOMResult.getNode().getFirstChild().getNodeName())) {
            HtmlDocument htmlDocument = (HtmlDocument)NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::HTML::Document").allocate();
            htmlDocument.setDocumentNode(threadContext, (Document)dOMResult.getNode());
            return htmlDocument;
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document"));
        xmlDocument.setDocumentNode(threadContext, (Document)dOMResult.getNode());
        return xmlDocument;
    }

    private Templates getTemplatesFromStreamSource() throws TransformerConfigurationException {
        if (this.stylesheet instanceof RubyString) {
            StringReader stringReader = new StringReader((String)this.stylesheet.toJava(String.class));
            StreamSource streamSource = new StreamSource(stringReader);
            return this.factory.newTemplates(streamSource);
        }
        return null;
    }

    private boolean isHtml(String string2) {
        Matcher matcher = html_tag.matcher(string2);
        return matcher.find();
    }

    private IRubyObject createDocumentFromString(ThreadContext threadContext, Ruby ruby2, String string2) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[4];
        iRubyObjectArray[0] = NokogiriHelpers.stringOrBlank(ruby2, string2);
        iRubyObjectArray[1] = ruby2.getNil();
        iRubyObjectArray[2] = ruby2.getNil();
        RubyClass rubyClass = (RubyClass)ruby2.getClassFromPath("Nokogiri::XML::ParseOptions");
        if (this.htmlish) {
            iRubyObjectArray[3] = rubyClass.getConstant("DEFAULT_HTML");
            RubyClass rubyClass2 = NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::HTML::Document");
            return RuntimeHelpers.invoke(threadContext, (IRubyObject)rubyClass2, "parse", iRubyObjectArray);
        }
        iRubyObjectArray[3] = rubyClass.getConstant("DEFAULT_XML");
        RubyClass rubyClass3 = NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document");
        XmlDocument xmlDocument = (XmlDocument)RuntimeHelpers.invoke(threadContext, (IRubyObject)rubyClass3, "parse", iRubyObjectArray);
        if (((Document)xmlDocument.getNode()).getDocumentElement() == null) {
            RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
            RuntimeHelpers.invoke(threadContext, (IRubyObject)rubyArray, "<<", iRubyObjectArray[0]);
        }
        return xmlDocument;
    }

    private void argumentTypeCheck(Ruby ruby2, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlDocument) {
            return;
        }
        throw ruby2.newArgumentError("argument must be a Nokogiri::XML::Document");
    }

    @JRubyMethod(name={"registr", "register"}, meta=true)
    public static IRubyObject register(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        throw threadContext.getRuntime().newNotImplementedError("Nokogiri::XSLT.register method is not implemented");
    }
}

