/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlNode;
import nokogiri.XmlRelaxng;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SchemaErrorHandler;
import nokogiri.internals.XmlDomParserContext;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::XML::Schema"})
public class XmlSchema
extends RubyObject {
    private Validator validator;

    public XmlSchema(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private Schema getSchema(Source source2, String string2, String string3) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        SchemaResourceResolver schemaResourceResolver = new SchemaResourceResolver(string2, string3, null);
        schemaFactory.setResourceResolver(schemaResourceResolver);
        return schemaFactory.newSchema(source2);
    }

    private void setValidator(Validator validator) {
        this.validator = validator;
    }

    static XmlSchema createSchemaInstance(ThreadContext threadContext, RubyClass rubyClass, Source source2) {
        Ruby ruby2 = threadContext.getRuntime();
        XmlSchema xmlSchema = (XmlSchema)NokogiriService.XML_SCHEMA_ALLOCATOR.allocate(ruby2, rubyClass);
        xmlSchema.setInstanceVariable("@errors", ruby2.newEmptyArray());
        try {
            Schema schema = xmlSchema.getSchema(source2, threadContext.getRuntime().getCurrentDirectory(), threadContext.getRuntime().getInstanceConfig().getScriptFileName());
            xmlSchema.setValidator(schema.newValidator());
            return xmlSchema;
        }
        catch (SAXException sAXException) {
            throw threadContext.getRuntime().newRuntimeError("Could not parse document: " + sAXException.getMessage());
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject from_document(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlDocument xmlDocument = (XmlDocument)((XmlNode)iRubyObject2).document(threadContext);
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        if (!rubyArray.isEmpty()) {
            throw new RaiseException((XmlSyntaxError)rubyArray.first());
        }
        DOMSource dOMSource = new DOMSource(xmlDocument.getDocument());
        IRubyObject iRubyObject3 = xmlDocument.url(threadContext);
        if (!iRubyObject3.isNil()) {
            dOMSource.setSystemId(iRubyObject3.convertToString().asJavaString());
        }
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, dOMSource);
    }

    private static IRubyObject getSchema(ThreadContext threadContext, RubyClass rubyClass, Source source2) {
        String string2 = rubyClass.getName();
        if ("Nokogiri::XML::Schema".equals(string2)) {
            return XmlSchema.createSchemaInstance(threadContext, rubyClass, source2);
        }
        if ("Nokogiri::XML::RelaxNG".equals(string2)) {
            return XmlRelaxng.createSchemaInstance(threadContext, rubyClass, source2);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(meta=true)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string2 = iRubyObject2.convertToString().asJavaString();
        return XmlSchema.getSchema(threadContext, (RubyClass)iRubyObject, new StreamSource(new StringReader(string2)));
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_document(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.validate_document_or_file(threadContext, (XmlDocument)iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject validate_file(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby2 = threadContext.getRuntime();
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(ruby2, RubyFixnum.newFixnum(ruby2, 1L));
        xmlDomParserContext.setInputSource(threadContext, iRubyObject, threadContext.getRuntime().getNil());
        XmlDocument xmlDocument = xmlDomParserContext.parse(threadContext, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document"), ruby2.getNil());
        return this.validate_document_or_file(threadContext, xmlDocument);
    }

    IRubyObject validate_document_or_file(ThreadContext threadContext, XmlDocument xmlDocument) {
        RubyArray rubyArray = (RubyArray)this.getInstanceVariable("@errors");
        SchemaErrorHandler schemaErrorHandler = new SchemaErrorHandler(threadContext.getRuntime(), rubyArray);
        this.setErrorHandler(schemaErrorHandler);
        try {
            this.validate(xmlDocument.getDocument());
        }
        catch (SAXException sAXException) {
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)NokogiriService.XML_SYNTAXERROR_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::SyntaxError"));
            xmlSyntaxError.setException(sAXException);
            rubyArray.append(xmlSyntaxError);
        }
        catch (IOException iOException) {
            throw threadContext.getRuntime().newIOError(iOException.getMessage());
        }
        return rubyArray;
    }

    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.validator.setErrorHandler(errorHandler);
    }

    protected void validate(Document document) throws SAXException, IOException {
        DOMSource dOMSource = new DOMSource(document);
        this.validator.validate(dOMSource);
    }

    private class SchemaLSInput
    implements LSInput {
        protected String fPublicId;
        protected String fSystemId;
        protected String fBaseSystemId;
        protected InputStream fByteStream;
        protected Reader fCharStream;
        protected String fData;
        protected String fEncoding;
        protected boolean fCertifiedText = false;

        private SchemaLSInput() {
        }

        public String getBaseURI() {
            return this.fBaseSystemId;
        }

        public InputStream getByteStream() {
            return this.fByteStream;
        }

        public boolean getCertifiedText() {
            return this.fCertifiedText;
        }

        public Reader getCharacterStream() {
            return this.fCharStream;
        }

        public String getEncoding() {
            return this.fEncoding;
        }

        public String getPublicId() {
            return this.fPublicId;
        }

        public String getStringData() {
            return this.fData;
        }

        public String getSystemId() {
            return this.fSystemId;
        }

        public void setBaseURI(String string2) {
            this.fBaseSystemId = string2;
        }

        public void setByteStream(InputStream inputStream) {
            this.fByteStream = inputStream;
        }

        public void setCertifiedText(boolean bl) {
            this.fCertifiedText = bl;
        }

        public void setCharacterStream(Reader reader) {
            this.fCharStream = reader;
        }

        public void setEncoding(String string2) {
            this.fEncoding = string2;
        }

        public void setPublicId(String string2) {
            this.fPublicId = string2;
        }

        public void setStringData(String string2) {
            this.fData = string2;
        }

        public void setSystemId(String string2) {
            this.fSystemId = string2;
        }
    }

    private class SchemaResourceResolver
    implements LSResourceResolver {
        SchemaLSInput lsInput;
        String currentDir;
        String scriptFileName;

        SchemaResourceResolver(String string2, String string3, Object object) {
            this.lsInput = new SchemaLSInput();
            this.currentDir = string2;
            this.scriptFileName = string3;
            if (object == null) {
                return;
            }
            if (object instanceof String) {
                this.lsInput.setStringData((String)object);
            } else if (object instanceof Reader) {
                this.lsInput.setCharacterStream((Reader)object);
            } else if (object instanceof InputStream) {
                this.lsInput.setByteStream((InputStream)object);
            }
        }

        public LSInput resolveResource(String string2, String string3, String string4, String string5, String string6) {
            String string7 = NokogiriHelpers.adjustSystemIdIfNecessary(this.currentDir, this.scriptFileName, string6, string5);
            this.lsInput.setPublicId(string4);
            this.lsInput.setSystemId(string7);
            this.lsInput.setBaseURI(string6);
            return this.lsInput;
        }
    }
}

