/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import nokogiri.NokogiriService;
import nokogiri.XmlSaxParserContext;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.ClosedStreamException;
import nokogiri.internals.NokogiriBlockingQueueInputStream;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Nokogiri::XML::SAX::PushParser"})
public class XmlSaxPushParser
extends RubyObject {
    ParserContext.Options options;
    IRubyObject optionsRuby;
    IRubyObject saxParser;
    NokogiriBlockingQueueInputStream stream;
    ParserTask parserTask = null;
    FutureTask<XmlSaxParserContext> futureTask = null;
    ExecutorService executor = null;

    public XmlSaxPushParser(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public void finalize() {
        this.terminateTask(null);
    }

    @JRubyMethod
    public IRubyObject initialize_native(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.optionsRuby = RuntimeHelpers.invoke(threadContext, threadContext.getRuntime().getClassFromPath("Nokogiri::XML::ParseOptions"), "new");
        this.options = new ParserContext.Options(0L);
        this.saxParser = iRubyObject;
        return this;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject getOptions(ThreadContext threadContext) {
        return RuntimeHelpers.invoke(threadContext, this.optionsRuby, "options");
    }

    @JRubyMethod(name={"options="})
    public IRubyObject setOptions(ThreadContext threadContext, IRubyObject iRubyObject) {
        RuntimeHelpers.invoke(threadContext, this.optionsRuby, "options=", iRubyObject);
        this.options = new ParserContext.Options(iRubyObject.convertToInteger().getLongValue());
        return this.getOptions(threadContext);
    }

    @JRubyMethod
    public IRubyObject native_write(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        try {
            this.initialize_task(threadContext);
        }
        catch (IOException iOException) {
            throw threadContext.getRuntime().newRuntimeError(iOException.getMessage());
        }
        byte[] byArray = null;
        if (!(iRubyObject instanceof RubyString) && !iRubyObject.respondsTo("to_str")) {
            this.terminateTask(threadContext);
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)NokogiriService.XML_SYNTAXERROR_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::SyntaxError"));
            throw new RaiseException(xmlSyntaxError);
        }
        byArray = iRubyObject.convertToString().getBytes();
        int n = this.parserTask.getErrorCount();
        if (iRubyObject2.isTrue()) {
            IRubyObject iRubyObject3 = RuntimeHelpers.invoke(threadContext, this, "document");
            RuntimeHelpers.invoke(threadContext, iRubyObject3, "end_document");
            this.terminateTask(threadContext);
        } else {
            try {
                Future<Void> future = this.stream.addChunk(new ByteArrayInputStream(byArray));
                future.get();
            }
            catch (ClosedStreamException closedStreamException) {
            }
            catch (Exception exception2) {
                throw threadContext.getRuntime().newRuntimeError(exception2.getMessage());
            }
        }
        if (!this.options.recover && this.parserTask.getErrorCount() > n) {
            this.terminateTask(threadContext);
            throw new RaiseException(this.parserTask.getLastError(), true);
        }
        return this;
    }

    private void initialize_task(ThreadContext threadContext) throws IOException {
        if (this.futureTask == null || this.stream == null) {
            this.stream = new NokogiriBlockingQueueInputStream();
            this.parserTask = new ParserTask(threadContext, this.saxParser);
            this.futureTask = new FutureTask<XmlSaxParserContext>(this.parserTask);
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread2 = new Thread(runnable);
                    thread2.setName("XmlSaxPushParser");
                    thread2.setDaemon(true);
                    return thread2;
                }
            });
            this.executor.submit(this.futureTask);
        }
    }

    private synchronized void terminateTask(ThreadContext threadContext) {
        block3: {
            try {
                Future<Void> future = this.stream.addChunk(NokogiriBlockingQueueInputStream.END);
                future.get();
            }
            catch (ClosedStreamException closedStreamException) {
            }
            catch (Exception exception2) {
                if (threadContext == null) break block3;
                throw threadContext.getRuntime().newRuntimeError(exception2.getMessage());
            }
        }
        this.futureTask.cancel(true);
        this.executor.shutdown();
        this.executor = null;
        this.stream = null;
        this.futureTask = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParserTask
    implements Callable<XmlSaxParserContext> {
        private final ThreadContext context;
        private final IRubyObject handler;
        private final XmlSaxParserContext parser;

        private ParserTask(ThreadContext threadContext, IRubyObject iRubyObject) {
            RubyClass rubyClass = NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::SAX::ParserContext");
            this.context = threadContext;
            this.handler = iRubyObject;
            this.parser = (XmlSaxParserContext)XmlSaxParserContext.parse_stream(threadContext, rubyClass, XmlSaxPushParser.this.stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XmlSaxParserContext call() throws Exception {
            try {
                this.parser.parse_with(this.context, this.handler);
            }
            finally {
                XmlSaxPushParser.this.stream.close();
            }
            return this.parser;
        }

        private synchronized int getErrorCount() {
            if (this.parser.getNokogiriHandler() == null) {
                return 0;
            }
            return this.parser.getNokogiriHandler().getErrorCount();
        }

        private synchronized RubyException getLastError() {
            return (RubyException)this.parser.getNokogiriHandler().getLastError();
        }
    }
}

