/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import nokogiri.HtmlDocument;
import nokogiri.NokogiriService;
import nokogiri.XmlAttr;
import nokogiri.XmlAttributeDecl;
import nokogiri.XmlDocument;
import nokogiri.XmlDocumentFragment;
import nokogiri.XmlElement;
import nokogiri.XmlElementDecl;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.HtmlDomParserContext;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Nokogiri::XML::Node"})
public class XmlNode
extends RubyObject {
    protected Node node;
    protected IRubyObject content = null;
    protected IRubyObject doc = null;
    protected IRubyObject name = null;
    protected static final int IDENTICAL_ELEMENTS = 0;
    protected static final int IN_DIFFERENT_DOCUMENTS = 1;
    protected static final int SECOND_PRECEDES_FIRST = 2;
    protected static final int FIRST_PRECEDES_SECOND = 4;
    protected static final int SECOND_CONTAINS_FIRST = 8;
    protected static final int FIRST_CONTAINS_SECOND = 16;

    protected static XmlNode asXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == null || !(iRubyObject instanceof XmlNode)) {
            Ruby ruby2 = threadContext.getRuntime();
            throw ruby2.newTypeError(iRubyObject, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Node"));
        }
        return (XmlNode)iRubyObject;
    }

    protected static XmlNode asXmlNodeOrNull(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject == null || iRubyObject.isNil()) {
            return null;
        }
        return XmlNode.asXmlNode(threadContext, iRubyObject);
    }

    public static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNode(threadContext, iRubyObject2);
        Node node = xmlNode.node;
        Node node2 = xmlNode2.node;
        node.setNodeValue(node.getNodeValue() + node2.getNodeValue());
        xmlNode.content = null;
        xmlNode2.assimilateXmlNode(threadContext, xmlNode);
    }

    protected static void coalesceTextNodes(ThreadContext threadContext, IRubyObject iRubyObject, AdoptScheme adoptScheme) {
        boolean bl;
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        XmlNode xmlNode2 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.previous_sibling(threadContext));
        XmlNode xmlNode3 = XmlNode.asXmlNodeOrNull(threadContext, xmlNode.next_sibling(threadContext));
        Node node = xmlNode2 == null ? null : xmlNode2.node;
        Node node2 = xmlNode.node;
        Node node3 = xmlNode3 == null ? null : xmlNode3.node;
        Node node4 = node2.getParentNode();
        boolean bl2 = adoptScheme == AdoptScheme.NEXT_SIBLING || adoptScheme == AdoptScheme.CHILD || adoptScheme == AdoptScheme.REPLACEMENT;
        boolean bl3 = bl = adoptScheme == AdoptScheme.PREV_SIBLING || adoptScheme == AdoptScheme.REPLACEMENT;
        if (bl && node3 != null && node3.getNodeType() == 3) {
            xmlNode.setContent(node2.getNodeValue() + node3.getNodeValue());
            node4.removeChild(node3);
            xmlNode3.assimilateXmlNode(threadContext, xmlNode);
        }
        if (bl2 && node != null && node.getNodeType() == 3) {
            xmlNode2.setContent(node.getNodeValue() + node2.getNodeValue());
            node4.removeChild(node2);
            xmlNode.assimilateXmlNode(threadContext, xmlNode2);
        }
    }

    public XmlNode(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public XmlNode(Ruby ruby2, RubyClass rubyClass, Node node) {
        super(ruby2, rubyClass);
        this.setNode(ruby2.getCurrentContext(), node);
    }

    protected void decorate(Ruby ruby2) {
        if (this.node != null) {
            this.resetCache();
            if (this.node.getNodeType() != 9) {
                this.doc = this.document(ruby2.getCurrentContext());
                if (this.doc != null && this.doc.isTrue()) {
                    RuntimeHelpers.invoke(ruby2.getCurrentContext(), this.doc, "decorate", (IRubyObject)this);
                }
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected void resetCache() {
        this.node.setUserData("NOKOGIRI_CACHED_NODE", this, null);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        Ruby ruby2 = threadContext.getRuntime();
        RubyClass rubyClass = (RubyClass)iRubyObject;
        if (iRubyObject.equals(NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Node"))) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Element");
        }
        XmlNode xmlNode = (XmlNode)rubyClass.allocate();
        xmlNode.init(threadContext, iRubyObjectArray);
        xmlNode.callInit(iRubyObjectArray, block);
        if (xmlNode.node == null) {
            threadContext.getRuntime().newRuntimeError("NODE IS NULL");
        }
        if (block.isGiven()) {
            block.call(threadContext, xmlNode);
        }
        return xmlNode;
    }

    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        Document document = XmlNode.asXmlNode(threadContext, iRubyObject2).getOwnerDocument();
        if (document == null) {
            throw this.getRuntime().newArgumentError("node must have owner document");
        }
        Element element = null;
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string3 = NokogiriHelpers.getPrefix(string2);
        if (string3 == null) {
            element = document.createElement(string2);
        } else {
            String string4 = null;
            if (document.getDocumentElement() != null) {
                string4 = document.getDocumentElement().lookupNamespaceURI(string3);
            }
            element = document.createElementNS(string4, string2);
        }
        this.setNode(threadContext, element);
    }

    protected void assimilateXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        this.node = xmlNode.node;
        this.content = null;
    }

    public void normalize() {
        this.node.normalize();
    }

    public Node getNode() {
        return this.node;
    }

    public static Node getNodeFromXmlNode(ThreadContext threadContext, IRubyObject iRubyObject) {
        return XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node;
    }

    protected String indentString(IRubyObject iRubyObject, String string2) {
        String[] stringArray = string2.split("\n");
        if (stringArray.length <= 1) {
            return string2;
        }
        String[] stringArray2 = new String[stringArray.length];
        boolean bl = false;
        String string3 = NokogiriHelpers.rubyStringToString(iRubyObject);
        int n = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringArray2[0] = stringArray[0];
        for (int j = 1; j < stringArray.length; ++j) {
            String string4 = stringArray[j].trim();
            if (string4.length() == 0) continue;
            if (string4.startsWith("</")) {
                bl = true;
                stringBuffer.setLength(Math.max(0, stringBuffer.length() - n));
            }
            stringArray2[j] = stringBuffer.toString() + string4;
            if (!string4.endsWith("/>") && !bl) {
                stringBuffer.append(string3);
            }
            bl = false;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int j = 0; j < stringArray2.length; ++j) {
            stringBuffer2.append(stringArray2[j]);
            stringBuffer2.append("\n");
        }
        return stringBuffer2.toString();
    }

    public boolean isComment() {
        return false;
    }

    public boolean isElement() {
        return this.node instanceof Element;
    }

    public boolean isProcessingInstruction() {
        return false;
    }

    protected IRubyObject getAttribute(ThreadContext threadContext, String string2) {
        return this.getAttribute(threadContext.getRuntime(), string2);
    }

    protected IRubyObject getAttribute(Ruby ruby2, String string2) {
        String string3 = this.getAttribute(string2);
        return NokogiriHelpers.nonEmptyStringOrNil(ruby2, string3);
    }

    protected String getAttribute(String string2) {
        if (this.node.getNodeType() != 1) {
            return null;
        }
        String string3 = ((Element)this.node).getAttribute(string2);
        return string3.length() == 0 ? null : string3;
    }

    public void post_add_child(ThreadContext threadContext, XmlNode xmlNode, XmlNode xmlNode2) {
    }

    public void relink_namespace(ThreadContext threadContext) {
        if (this.node instanceof Element) {
            Object object;
            Element element = (Element)this.node;
            String string2 = element.getPrefix();
            String string3 = element.getNamespaceURI();
            if (string2 == null && string3 == null) {
                string2 = NokogiriHelpers.getPrefix(element.getNodeName());
            } else if (string3 != null) {
                string2 = element.lookupPrefix(string3);
            }
            element.getOwnerDocument().setStrictErrorChecking(false);
            String string4 = element.lookupNamespaceURI(string2);
            this.node = NokogiriHelpers.renameNode(element, string4, element.getNodeName());
            if (element.hasAttributes()) {
                object = element.getAttributes();
                for (int j = 0; j < object.getLength(); ++j) {
                    Attr attr2 = (Attr)object.item(j);
                    String string5 = "";
                    String string6 = attr2.getPrefix();
                    if (string6 == null) {
                        string6 = NokogiriHelpers.getPrefix(attr2.getNodeName());
                    }
                    String string7 = attr2.getNodeName();
                    string5 = "xml".equals(string2) ? "http://www.w3.org/XML/1998/namespace" : ("xmlns".equals(string6) || string7.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : attr2.lookupNamespaceURI(string6));
                    if (string5 != null && !"".equals(string5)) {
                        XmlNamespace.createFromAttr(threadContext.getRuntime(), attr2);
                    }
                    NokogiriHelpers.renameNode(attr2, string5, string7);
                }
            }
            if (this.node.hasChildNodes()) {
                object = (XmlNodeSet)this.children(threadContext);
                ((XmlNodeSet)object).relink_namespace(threadContext);
            }
        }
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter(this.node);
        XmlNodeSet xmlNodeSet = (XmlNodeSet)this.children(threadContext);
        if (xmlNodeSet.length() > 0L) {
            RubyArray rubyArray = (RubyArray)xmlNodeSet.to_a(threadContext);
            for (int j = 0; j < rubyArray.getLength(); ++j) {
                RubyObject rubyObject;
                Object object = rubyArray.get(j);
                if (object instanceof XmlNode) {
                    rubyObject = (XmlNode)object;
                    ((XmlNode)rubyObject).accept(threadContext, saveContextVisitor);
                    continue;
                }
                if (!(object instanceof XmlNamespace)) continue;
                rubyObject = (XmlNamespace)object;
                ((XmlNamespace)rubyObject).accept(threadContext, saveContextVisitor);
            }
        }
        saveContextVisitor.leave(this.node);
    }

    public void setName(IRubyObject iRubyObject) {
        this.name = iRubyObject;
    }

    public void setDocument(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.doc = iRubyObject;
        this.setInstanceVariable("@document", iRubyObject);
        if (iRubyObject != null) {
            RuntimeHelpers.invoke(threadContext, iRubyObject, "decorate", (IRubyObject)this);
        }
    }

    public void setNode(ThreadContext threadContext, Node node) {
        this.node = node;
        this.decorate(threadContext.getRuntime());
        if (this instanceof XmlAttr) {
            ((XmlAttr)this).setNamespaceIfNecessary(threadContext.getRuntime());
        }
    }

    public void updateNodeNamespaceIfNecessary(ThreadContext threadContext, XmlNamespace xmlNamespace) {
        boolean bl;
        String string2 = this.node.getPrefix();
        String string3 = NokogiriHelpers.rubyStringToString(xmlNamespace.href(threadContext));
        boolean bl2 = bl = string2 == null && xmlNamespace.prefix(threadContext).isNil() || string2 != null && !xmlNamespace.prefix(threadContext).isNil() && string2.equals(NokogiriHelpers.rubyStringToString(xmlNamespace.prefix(threadContext)));
        if (bl) {
            this.node = NokogiriHelpers.renameNode(this.node, string3, this.node.getNodeName());
        }
    }

    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name != null) {
            return this.name;
        }
        String string2 = null;
        if (this.name == null && this.node != null) {
            string2 = this.node.getNodeName();
            string2 = NokogiriHelpers.getLocalPart(string2);
        }
        if (string2 == null) {
            string2 = "";
        }
        this.name = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), string2);
        return this.name;
    }

    @JRubyMethod(name={"add_namespace_definition", "add_namespace"})
    public IRubyObject add_namespace_definition(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object;
        Node node;
        if (this.node.getNodeType() == 1) {
            node = this.node;
            object = (Element)this.node;
            String string2 = iRubyObject.isNil() ? "xmlns" : "xmlns:" + NokogiriHelpers.rubyStringToString(iRubyObject);
            object.setAttributeNS("http://www.w3.org/2000/xmlns/", string2, NokogiriHelpers.rubyStringToString(iRubyObject2));
        } else {
            node = this.node.getNodeType() == 2 ? ((Attr)this.node).getOwnerElement() : this.node.getParentNode();
        }
        object = XmlNamespace.createFromPrefixAndHref(node, iRubyObject, iRubyObject2);
        if (this.node != node) {
            this.node = NokogiriHelpers.renameNode(this.node, ((XmlNamespace)object).getHref(), ((XmlNamespace)object).getPrefix() + this.node.getLocalName());
        }
        this.updateNodeNamespaceIfNecessary(threadContext, (XmlNamespace)object);
        return object;
    }

    @JRubyMethod(name={"attribute", "attr"})
    public IRubyObject attribute(ThreadContext threadContext, IRubyObject iRubyObject) {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        Node node = namedNodeMap.getNamedItem(NokogiriHelpers.rubyStringToString(iRubyObject));
        if (node == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
    }

    @JRubyMethod
    public IRubyObject attribute_nodes(ThreadContext threadContext) {
        NamedNodeMap namedNodeMap = this.node.getAttributes();
        Ruby ruby2 = threadContext.getRuntime();
        if (namedNodeMap == null) {
            return ruby2.newEmptyArray();
        }
        RubyArray rubyArray = ruby2.newArray();
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            if (!(this.doc instanceof HtmlDocument) && NokogiriHelpers.isNamespace(namedNodeMap.item(j))) continue;
            rubyArray.append(NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), namedNodeMap.item(j)));
        }
        return rubyArray;
    }

    @JRubyMethod
    public IRubyObject attribute_with_ns(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string3 = iRubyObject2.isNil() ? null : NokogiriHelpers.rubyStringToString(iRubyObject2);
        Node node = this.node.getAttributes().getNamedItemNS(string3, string2);
        if (node == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
    }

    @JRubyMethod(name={"blank?"})
    public IRubyObject blank_p(ThreadContext threadContext) {
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            String string2 = this.node.getTextContent();
            if (string2 == null) {
                return threadContext.getRuntime().getTrue();
            }
            if ("".equals(string2.trim())) {
                return threadContext.getRuntime().getTrue();
            }
        }
        return threadContext.getRuntime().getFalse();
    }

    @JRubyMethod
    public IRubyObject child(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getFirstChild());
    }

    @JRubyMethod
    public IRubyObject children(ThreadContext threadContext) {
        XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::NodeSet"));
        xmlNodeSet.setNodeList(this.node.getChildNodes());
        return xmlNodeSet;
    }

    @JRubyMethod
    public IRubyObject first_element_child(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, true);
        if (arrayList.size() == 0) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), (Node)arrayList.get(0));
    }

    @JRubyMethod
    public IRubyObject last_element_child(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, false);
        if (arrayList.size() == 0) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), (Node)arrayList.get(arrayList.size() - 1));
    }

    @JRubyMethod(name={"element_children", "elements"})
    public IRubyObject element_children(ThreadContext threadContext) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        this.addElements(this.node, arrayList, false);
        if (arrayList.size() == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext);
        }
        RubyArray rubyArray = NokogiriHelpers.nodeArrayToRubyArray(threadContext.getRuntime(), arrayList.toArray(new Node[0]));
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, rubyArray);
        return xmlNodeSet;
    }

    private void addElements(Node node, List<Node> list2, boolean bl) {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node2 = nodeList.item(j);
            if (node2.getNodeType() != 1) continue;
            list2.add(node2);
            if (!bl) continue;
            return;
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject compare(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof XmlNode)) {
            return threadContext.getRuntime().newFixnum(-2);
        }
        Node node = XmlNode.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject).node;
        if (this.node.getNodeType() == 9 || node.getNodeType() == 9) {
            return threadContext.getRuntime().newFixnum(-1);
        }
        try {
            short s2 = this.node.compareDocumentPosition(node);
            if ((s2 & 4) == 4) {
                return threadContext.getRuntime().newFixnum(-1);
            }
            if ((s2 & 2) == 2) {
                return threadContext.getRuntime().newFixnum(1);
            }
            if (s2 == 0) {
                return threadContext.getRuntime().newFixnum(0);
            }
            return threadContext.getRuntime().newFixnum(-2);
        }
        catch (Exception exception2) {
            return threadContext.getRuntime().newFixnum(-2);
        }
    }

    @JRubyMethod(required=2, visibility=Visibility.PRIVATE)
    public IRubyObject in_context(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        Object object;
        ByteArrayInputStream byteArrayInputStream;
        XmlDomParserContext xmlDomParserContext;
        RubyClass rubyClass;
        IRubyObject iRubyObject3 = this.document(threadContext);
        Ruby ruby2 = threadContext.getRuntime();
        if (iRubyObject3 == null || !(iRubyObject3 instanceof XmlDocument)) {
            return ruby2.getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObject3;
        if (xmlDocument instanceof HtmlDocument) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::HTML::Document");
            xmlDomParserContext = new HtmlDomParserContext(ruby2, iRubyObject2);
            ((HtmlDomParserContext)xmlDomParserContext).enableDocumentFragment();
            byteArrayInputStream = new ByteArrayInputStream(NokogiriHelpers.rubyStringToString(iRubyObject).getBytes());
        } else if (xmlDocument instanceof XmlDocument) {
            rubyClass = NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document");
            xmlDomParserContext = new XmlDomParserContext(ruby2, iRubyObject2);
            object = NokogiriHelpers.rubyStringToString(iRubyObject);
            byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes());
        } else {
            return ruby2.getNil();
        }
        xmlDomParserContext.setInputSource(byteArrayInputStream);
        object = xmlDomParserContext.parse(threadContext, rubyClass, ruby2.getNil());
        RubyArray rubyArray = this.getErrorArray(xmlDocument);
        RubyArray rubyArray2 = this.getErrorArray((XmlDocument)object);
        if (this.isErrorIncreased(rubyArray, rubyArray2)) {
            for (int j = 0; j < rubyArray2.getLength(); ++j) {
                rubyArray.add(rubyArray2.get(j));
            }
            xmlDocument.setInstanceVariable("@errors", rubyArray);
            XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, RubyArray.newArray(ruby2));
            return xmlNodeSet;
        }
        Node node = ((XmlDocument)object).node.getFirstChild().getNodeType() == 10 ? ((XmlDocument)object).node.getFirstChild().getNextSibling() : ((XmlDocument)object).node.getFirstChild();
        RubyArray rubyArray3 = RubyArray.newArray(ruby2);
        rubyArray3.add(NokogiriHelpers.getCachedNodeOrCreate(ruby2, node));
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, rubyArray3);
        return xmlNodeSet;
    }

    private RubyArray getErrorArray(XmlDocument xmlDocument) {
        IRubyObject iRubyObject = xmlDocument.getInstanceVariable("@errors");
        if (iRubyObject != null && iRubyObject instanceof RubyArray) {
            return (RubyArray)iRubyObject;
        }
        return RubyArray.newArray(xmlDocument.getRuntime());
    }

    private boolean isErrorIncreased(RubyArray rubyArray, RubyArray rubyArray2) {
        RubyFixnum rubyFixnum = ((RubyArray)rubyArray2.op_diff(rubyArray)).length();
        int n = (Integer)rubyFixnum.toJava(Integer.class);
        return n > 0;
    }

    @JRubyMethod(name={"content", "text", "inner_text"})
    public IRubyObject content(ThreadContext threadContext) {
        String string2;
        if (!(this.node.hasChildNodes() || this.node.getNodeValue() != null || this.node.getNodeType() != 3 && this.node.getNodeType() != 4)) {
            return threadContext.nil;
        }
        if (this instanceof XmlDocument) {
            Element element = ((Document)this.node).getDocumentElement();
            if (element == null) {
                string2 = "";
            } else {
                Element element2 = ((Document)this.node).getDocumentElement();
                StringBuffer stringBuffer = new StringBuffer();
                this.getTextContentRecursively(threadContext, stringBuffer, element2);
                string2 = stringBuffer.toString();
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            this.getTextContentRecursively(threadContext, stringBuffer, this.node);
            string2 = stringBuffer.toString();
        }
        NokogiriHelpers.convertEncodingByNKFIfNecessary(threadContext.getRuntime(), (XmlDocument)this.document(threadContext), string2);
        return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string2);
    }

    private void getTextContentRecursively(ThreadContext threadContext, StringBuffer stringBuffer, Node node) {
        String string2 = node.getNodeValue();
        if (string2 != null && NokogiriHelpers.shouldDecode(node)) {
            string2 = NokogiriHelpers.decodeJavaString(string2);
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        NodeList nodeList = node.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node2 = nodeList.item(j);
            if (!this.hasTextContent(node2)) continue;
            this.getTextContentRecursively(threadContext, stringBuffer, node2);
        }
    }

    private boolean hasTextContent(Node node) {
        return node.getNodeType() != 8 && node.getNodeType() != 7;
    }

    @JRubyMethod
    public IRubyObject document(ThreadContext threadContext) {
        if (this.doc == null) {
            this.doc = (XmlDocument)this.node.getOwnerDocument().getUserData("NOKOGIRI_CACHED_NODE");
        }
        if (this.doc == null) {
            this.doc = NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getOwnerDocument());
            this.node.getOwnerDocument().setUserData("NOKOGIRI_CACHED_NODE", this.doc, null);
        }
        return this.doc;
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext) {
        return this.dup_implementation(threadContext, true);
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext, IRubyObject iRubyObject) {
        boolean bl = (Integer)iRubyObject.toJava(Integer.class) != 0;
        return this.dup_implementation(threadContext, bl);
    }

    protected IRubyObject dup_implementation(ThreadContext threadContext, boolean bl) {
        Node node;
        XmlNode xmlNode;
        try {
            xmlNode = (XmlNode)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw threadContext.getRuntime().newRuntimeError(cloneNotSupportedException.toString());
        }
        if (this.node == null) {
            throw threadContext.getRuntime().newRuntimeError("FFFFFFFFFUUUUUUU");
        }
        xmlNode.node = node = this.node.cloneNode(bl);
        return xmlNode;
    }

    public static IRubyObject encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        String string3 = NokogiriHelpers.encodeJavaString(string2);
        return threadContext.getRuntime().newString(string3);
    }

    @JRubyMethod(name={"encode_special_chars"})
    public IRubyObject i_encode_special_chars(ThreadContext threadContext, IRubyObject iRubyObject) {
        return XmlNode.encode_special_chars(threadContext, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            String string2;
            Element element;
            if (iRubyObject == null || iRubyObject.isNil()) {
                threadContext.getRuntime().getNil();
            }
            if (!(element = (Element)this.node).hasAttribute(string2 = NokogiriHelpers.rubyStringToString(iRubyObject))) {
                return threadContext.getRuntime().getNil();
            }
            String string3 = element.getAttribute(string2);
            return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), string3);
        }
        return threadContext.getRuntime().getNil();
    }

    protected Document getOwnerDocument() {
        if (this.node.getNodeType() == 9) {
            return (Document)this.node;
        }
        return this.node.getOwnerDocument();
    }

    @JRubyMethod
    public IRubyObject internal_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getInternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_internal_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.internal_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.getRuntime().newRuntimeError("Document already has internal subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createInternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod
    public IRubyObject external_subset(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject = xmlDocument.getExternalSubset(threadContext);
        return iRubyObject;
    }

    @JRubyMethod
    public IRubyObject create_external_subset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        IRubyObject iRubyObject4 = this.external_subset(threadContext);
        if (!iRubyObject4.isNil()) {
            throw threadContext.getRuntime().newRuntimeError("Document already has external subset");
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), document);
        IRubyObject iRubyObject5 = xmlDocument.createExternalSubset(threadContext, iRubyObject, iRubyObject2, iRubyObject3);
        return iRubyObject5;
    }

    @JRubyMethod(name={"key?", "has_attribute?"})
    public IRubyObject key_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
            Element element = (Element)this.node;
            return threadContext.getRuntime().newBoolean(element.hasAttribute(string2));
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject namespace(ThreadContext threadContext) {
        String string2;
        if (this.doc instanceof HtmlDocument) {
            return threadContext.getRuntime().getNil();
        }
        XmlDocument xmlDocument = (XmlDocument)this.doc;
        NokogiriNamespaceCache nokogiriNamespaceCache = xmlDocument.getNamespaceCache();
        XmlNamespace xmlNamespace = nokogiriNamespaceCache.get((string2 = this.node.getPrefix()) == null ? "" : string2, this.node.getNamespaceURI());
        if (xmlNamespace == null || xmlNamespace.isEmpty()) {
            return threadContext.getRuntime().getNil();
        }
        return xmlNamespace;
    }

    @JRubyMethod
    public IRubyObject namespace_definitions(ThreadContext threadContext) {
        Ruby ruby2 = threadContext.getRuntime();
        RubyArray rubyArray = ruby2.newArray();
        if (this.doc == null) {
            return rubyArray;
        }
        if (this.doc instanceof HtmlDocument) {
            return rubyArray;
        }
        List<XmlNamespace> list2 = ((XmlDocument)this.doc).getNamespaceCache().get(this.node);
        for (XmlNamespace xmlNamespace : list2) {
            rubyArray.append(xmlNamespace);
        }
        return rubyArray;
    }

    @JRubyMethod
    public IRubyObject namespace_scopes(ThreadContext threadContext) {
        RubyArray rubyArray = (RubyArray)this.namespace_definitions(threadContext);
        IRubyObject iRubyObject = this.parent(threadContext);
        RubyArray rubyArray2 = !iRubyObject.isNil() ? (RubyArray)((XmlNode)iRubyObject).namespace_scopes(threadContext) : this.getRuntime().newEmptyArray();
        return rubyArray2.op_plus(rubyArray);
    }

    @JRubyMethod(name={"namespaced_key?"})
    public IRubyObject namespaced_key_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.attribute_with_ns(threadContext, iRubyObject, iRubyObject2).isNil() ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
    }

    protected void setContent(IRubyObject iRubyObject) {
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        this.node.setTextContent(string2);
        if (string2.length() == 0) {
            return;
        }
        if (this.node.getNodeType() == 3 || this.node.getNodeType() == 4) {
            return;
        }
        if (this.node.getFirstChild() != null) {
            this.node.getFirstChild().setUserData("NOKOGIRI_ENCODED_STRING", true, null);
        }
    }

    private void setContent(String string2) {
        this.node.setTextContent(string2);
        this.content = null;
    }

    @JRubyMethod(name={"native_content="})
    public IRubyObject native_content_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.setContent(iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(required=4, visibility=Visibility.PRIVATE)
    public IRubyObject native_write_to(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        IRubyObject iRubyObject3 = iRubyObjectArray[2];
        IRubyObject iRubyObject4 = iRubyObjectArray[3];
        String string2 = iRubyObject2.isNil() ? null : NokogiriHelpers.rubyStringToString(iRubyObject2);
        SaveContextVisitor saveContextVisitor = new SaveContextVisitor((Integer)iRubyObject4.toJava(Integer.class), NokogiriHelpers.rubyStringToString(iRubyObject3), string2, this.isHtmlDoc(threadContext), this.isFragment(), 0);
        this.accept(threadContext, saveContextVisitor);
        IRubyObject iRubyObject5 = null;
        if (NokogiriHelpers.isUTF8(string2)) {
            iRubyObject5 = NokogiriHelpers.stringOrNil(threadContext.getRuntime(), saveContextVisitor.toString());
        } else {
            try {
                byte[] byArray = NokogiriHelpers.convertEncoding(Charset.forName(string2), saveContextVisitor.toString());
                iRubyObject5 = NokogiriHelpers.stringOrNil(threadContext.getRuntime(), byArray);
            }
            catch (CharacterCodingException characterCodingException) {
                throw threadContext.getRuntime().newRuntimeError(characterCodingException.getMessage());
            }
        }
        RuntimeHelpers.invoke(threadContext, iRubyObject, "write", iRubyObject5);
        return iRubyObject;
    }

    private boolean isHtmlDoc(ThreadContext threadContext) {
        return this.document(threadContext).getMetaClass().isKindOfModule(NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"));
    }

    private boolean isFragment() {
        if (this.node instanceof DocumentFragment) {
            return true;
        }
        return this.node.getParentNode() != null && this.node.getParentNode() instanceof DocumentFragment;
    }

    @JRubyMethod(name={"next_sibling", "next"})
    public IRubyObject next_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getNextSibling());
    }

    @JRubyMethod(name={"previous_sibling", "previous"})
    public IRubyObject previous_sibling(ThreadContext threadContext) {
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getPreviousSibling());
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject new_from_str(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument = (XmlDocument)XmlDocument.read_memory(threadContext, iRubyObjectArray);
        return xmlDocument.root(threadContext);
    }

    @JRubyMethod(name={"node_name", "name"})
    public IRubyObject node_name(ThreadContext threadContext) {
        return this.getNodeName(threadContext);
    }

    @JRubyMethod(name={"node_name=", "name="})
    public IRubyObject node_name_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        this.node = NokogiriHelpers.renameNode(this.node, null, string2);
        this.setName(iRubyObject);
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.node instanceof Element) {
            String string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
            String string3 = NokogiriHelpers.rubyStringToString(iRubyObject2);
            Element element = (Element)this.node;
            String string4 = null;
            int n = string2.indexOf(":");
            if (n > 0) {
                String string5 = string2.substring(0, n);
                string4 = string5.equals("xml") ? "http://www.w3.org/XML/1998/namespace" : (string5.equals("xmlns") ? "http://www.w3.org/2000/xmlns/" : this.findNamespaceHref(threadContext, string5));
            }
            if (string4 != null) {
                element.setAttributeNS(string4, string2, string3);
            } else {
                element.setAttribute(string2, string3);
            }
            return this;
        }
        return iRubyObject2;
    }

    private String findNamespaceHref(ThreadContext threadContext, String string2) {
        for (XmlNode xmlNode = this; xmlNode != this.document(threadContext); xmlNode = (XmlNode)xmlNode.parent(threadContext)) {
            RubyArray rubyArray = (RubyArray)xmlNode.namespace_scopes(threadContext);
            for (XmlNamespace xmlNamespace : rubyArray) {
                if (!xmlNamespace.getPrefix().equals(string2)) continue;
                return xmlNamespace.getHref();
            }
            if (xmlNode.parent(threadContext).isNil()) break;
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject parent(ThreadContext threadContext) {
        if (this.node.getOwnerDocument() != null && this.node.getOwnerDocument().getDocumentElement() == this.node) {
            return this.document(threadContext);
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), this.node.getParentNode());
    }

    @JRubyMethod
    public IRubyObject path(ThreadContext threadContext) {
        return RubyString.newString(threadContext.getRuntime(), NokogiriHelpers.getNodeCompletePath(this.node));
    }

    @JRubyMethod
    public IRubyObject pointer_id(ThreadContext threadContext) {
        return RubyFixnum.newFixnum(threadContext.getRuntime(), this.node.hashCode());
    }

    @JRubyMethod(name={"remove_attribute", "delete"})
    public IRubyObject remove_attribute(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.node instanceof Element) {
            String string2 = iRubyObject.convertToString().asJavaString();
            Element element = (Element)this.node;
            element.removeAttribute(string2);
        }
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject set_namespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            if (this.doc != null) {
                Node node = this.node;
                String string2 = node.getPrefix();
                String string3 = node.getNamespaceURI();
                ((XmlDocument)this.doc).getNamespaceCache().remove(string2 == null ? "" : string2, string3);
                this.node = NokogiriHelpers.renameNode(node, null, NokogiriHelpers.getLocalPart(node.getNodeName()));
            }
        } else {
            XmlNamespace xmlNamespace = (XmlNamespace)iRubyObject;
            String string4 = NokogiriHelpers.rubyStringToString(xmlNamespace.prefix(threadContext));
            String string5 = NokogiriHelpers.rubyStringToString(xmlNamespace.href(threadContext));
            String string6 = NokogiriHelpers.newQName(string4, this.node);
            this.node = NokogiriHelpers.renameNode(this.node, string5, string6);
        }
        return this;
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        if (this.node.getParentNode() == null) {
            throw threadContext.getRuntime().newRuntimeError("TYPE: " + this.node.getNodeType() + " PARENT NULL");
        }
        this.node.getParentNode().removeChild(this.node);
        return this;
    }

    @JRubyMethod(name={"node_type", "type"})
    public IRubyObject node_type(ThreadContext threadContext) {
        String string2;
        switch (this.node.getNodeType()) {
            case 1: {
                if (this instanceof XmlElementDecl) {
                    string2 = "ELEMENT_DECL";
                    break;
                }
                if (this instanceof XmlAttributeDecl) {
                    string2 = "ATTRIBUTE_DECL";
                    break;
                }
                if (this instanceof XmlEntityDecl) {
                    string2 = "ENTITY_DECL";
                    break;
                }
                string2 = "ELEMENT_NODE";
                break;
            }
            case 2: {
                string2 = "ATTRIBUTE_NODE";
                break;
            }
            case 3: {
                string2 = "TEXT_NODE";
                break;
            }
            case 4: {
                string2 = "CDATA_SECTION_NODE";
                break;
            }
            case 5: {
                string2 = "ENTITY_REF_NODE";
                break;
            }
            case 6: {
                string2 = "ENTITY_NODE";
                break;
            }
            case 7: {
                string2 = "PI_NODE";
                break;
            }
            case 8: {
                string2 = "COMMENT_NODE";
                break;
            }
            case 9: {
                if (this instanceof HtmlDocument) {
                    string2 = "HTML_DOCUMENT_NODE";
                    break;
                }
                string2 = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                string2 = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 11: {
                string2 = "DOCUMENT_FRAG_NODE";
                break;
            }
            case 12: {
                string2 = "NOTATION_NODE";
                break;
            }
            default: {
                return threadContext.getRuntime().newFixnum(0);
            }
        }
        return NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Node").getConstant(string2);
    }

    @JRubyMethod
    public IRubyObject line(ThreadContext threadContext) {
        Document document = this.getOwnerDocument();
        int[] nArray = new int[1];
        this.count(document, nArray);
        return RubyFixnum.newFixnum(threadContext.getRuntime(), nArray[0] + 1);
    }

    private boolean count(Node node, int[] nArray) {
        if (node == this.node) {
            return true;
        }
        NodeList nodeList = node.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node node2 = nodeList.item(j);
            if (node2 instanceof Text && ((Text)node2).getData().contains("\n")) {
                nArray[0] = nArray[0] + 1;
            }
            if (!this.count(node2, nArray)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod
    public IRubyObject next_element(ThreadContext threadContext) {
        Node node = this.node.getNextSibling();
        Ruby ruby2 = threadContext.getRuntime();
        if (node == null) {
            return ruby2.getNil();
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            return ruby2.getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node2);
    }

    @JRubyMethod
    public IRubyObject previous_element(ThreadContext threadContext) {
        Node node = this.node.getPreviousSibling();
        Ruby ruby2 = threadContext.getRuntime();
        if (node == null) {
            return ruby2.getNil();
        }
        if (node instanceof Element) {
            return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            return ruby2.getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node2);
    }

    protected IRubyObject adoptAs(ThreadContext threadContext, AdoptScheme adoptScheme, IRubyObject iRubyObject) {
        XmlNode xmlNode = XmlNode.asXmlNode(threadContext, iRubyObject);
        if (this.doc != null) {
            xmlNode.setDocument(threadContext, this.doc);
        }
        RubyObject rubyObject = xmlNode;
        Node node = this.node;
        Node node2 = xmlNode.node;
        try {
            Node node3;
            Document document = node2.getOwnerDocument();
            Document document2 = node.getOwnerDocument();
            if (document2 != null && document2 != node2.getOwnerDocument()) {
                node3 = document2.adoptNode(node2);
                this.fixUserData(document, node3);
                if (node3 == null) {
                    throw threadContext.getRuntime().newRuntimeError("Failed to take ownership of node");
                }
                node2 = node3;
            }
            node3 = node.getParentNode();
            switch (adoptScheme) {
                case CHILD: {
                    Node[] nodeArray = this.adoptAsChild(threadContext, node, node2);
                    if (nodeArray.length == 1 && node2 == nodeArray[0]) break;
                    rubyObject = NokogiriHelpers.nodeArrayToRubyArray(threadContext.getRuntime(), nodeArray);
                    break;
                }
                case PREV_SIBLING: {
                    this.adoptAsPrevSibling(threadContext, node3, node, node2);
                    break;
                }
                case NEXT_SIBLING: {
                    this.adoptAsNextSibling(threadContext, node3, node, node2);
                    break;
                }
                case REPLACEMENT: {
                    this.adoptAsReplacement(threadContext, node3, node, node2);
                }
            }
        }
        catch (Exception exception2) {
            throw threadContext.getRuntime().newRuntimeError(exception2.toString());
        }
        if (node2.getNodeType() == 3) {
            XmlNode.coalesceTextNodes(threadContext, (IRubyObject)xmlNode, adoptScheme);
        }
        this.relink_namespace(threadContext);
        return rubyObject;
    }

    private void fixUserData(Document document, Node node) {
        String string2 = "NOKOGIRI_ENCODED_STRING";
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
            node2.setUserData(string2, coreDocumentImpl.getUserData(node2, string2), null);
            this.fixUserData(document, node2);
        }
    }

    protected Node[] adoptAsChild(ThreadContext threadContext, Node node, Node nodeArray) {
        Node[] nodeArray2;
        if (node.getNodeType() == 9 && nodeArray.getNodeType() == 3) {
            nodeArray2 = ((Document)node).createElement("nokogiri_text_wrapper");
            nodeArray2.appendChild((Node)nodeArray);
            nodeArray = nodeArray2;
        }
        this.addNamespaceURIIfNeeded((Node)nodeArray);
        node.appendChild((Node)nodeArray);
        nodeArray2 = new Node[]{nodeArray};
        return nodeArray2;
    }

    private void addNamespaceURIIfNeeded(Node node) {
        if (this instanceof XmlDocumentFragment && ((XmlDocumentFragment)this).getFragmentContext() != null) {
            XmlElement xmlElement = ((XmlDocumentFragment)this).getFragmentContext();
            String string2 = xmlElement.node.getNamespaceURI();
            if (string2 != null && string2.length() > 0) {
                NokogiriHelpers.renameNode(node, string2, node.getNodeName());
            }
        }
    }

    protected void adoptAsPrevSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        node.insertBefore(node3, node2);
    }

    protected void adoptAsNextSibling(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            if (node3.getParentNode() != null) {
                node3.getParentNode().removeChild(node3);
            }
            return;
        }
        Node node4 = node2.getNextSibling();
        if (node4 != null && node4.getNodeType() == 3 && node3.getNodeType() == 3) {
            return;
        }
        if (node4 != null) {
            node.insertBefore(node3, node4);
        } else {
            node.appendChild(node3);
        }
    }

    protected void adoptAsReplacement(ThreadContext threadContext, Node node, Node node2, Node node3) {
        if (node == null) {
            return;
        }
        try {
            node.replaceChild(node3, node2);
            if (node3.getNodeType() != 3) {
                NokogiriHelpers.renameNode(node3, node2.getNamespaceURI(), node3.getNodeName());
            }
        }
        catch (Exception exception2) {
            String string2 = "could not replace child: ";
            throw threadContext.getRuntime().newRuntimeError(string2 + exception2.toString());
        }
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_child_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.CHILD, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject replace_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.REPLACEMENT, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_previous_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.PREV_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject add_next_sibling_node(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.adoptAs(threadContext, AdoptScheme.NEXT_SIBLING, iRubyObject);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject process_xincludes(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlDocument xmlDocument = (XmlDocument)this.document(threadContext);
        RubyArray rubyArray = (RubyArray)xmlDocument.getInstanceVariable("@errors");
        while (rubyArray.getLength() > 0) {
            XmlSyntaxError xmlSyntaxError = (XmlSyntaxError)rubyArray.shift(threadContext);
            if (!xmlSyntaxError.toString().contains("Include operation failed")) continue;
            throw new RaiseException(xmlSyntaxError);
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AdoptScheme {
        CHILD,
        PREV_SIBLING,
        NEXT_SIBLING,
        REPLACEMENT;

    }
}

