/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::EntityReference"}, parent="Nokogiri::XML::Node")
public class XmlEntityReference
extends XmlNode {
    public XmlEntityReference(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public XmlEntityReference(Ruby ruby2, RubyClass rubyClass, Node node) {
        super(ruby2, rubyClass, node);
    }

    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        Document document = ((XmlNode)iRubyObject).getOwnerDocument();
        CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)document;
        boolean bl = coreDocumentImpl.getErrorChecking();
        coreDocumentImpl.setErrorChecking(false);
        EntityReference entityReference = document.createEntityReference(NokogiriHelpers.rubyStringToString(iRubyObject2));
        coreDocumentImpl.setErrorChecking(bl);
        this.setNode(threadContext, entityReference);
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter(this.node);
        for (Node node = this.node.getFirstChild(); node != null; node = node.getNextSibling()) {
            RubyObject rubyObject;
            IRubyObject iRubyObject = NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
            if (iRubyObject instanceof XmlNode) {
                rubyObject = (XmlNode)iRubyObject;
                ((XmlNode)rubyObject).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (!(iRubyObject instanceof XmlNamespace)) continue;
            rubyObject = (XmlNamespace)iRubyObject;
            ((XmlNamespace)rubyObject).accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(this.node);
    }
}

