/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.XmlElement;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;

@JRubyClass(name={"Nokogiri::XML::DocumentFragment"}, parent="Nokogiri::XML::Node")
public class XmlDocumentFragment
extends XmlNode {
    private XmlElement fragmentContext = null;
    private static Pattern qname_pattern = Pattern.compile("[^</:>\\s]+:[^</:>=\\s]+");
    private static Pattern starttag_pattern = Pattern.compile("<[^</>]+>");

    public XmlDocumentFragment(Ruby ruby2) {
        this(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::DocumentFragment"));
    }

    public XmlDocumentFragment(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    @JRubyMethod(name={"new"}, meta=true, required=1, optional=2)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 1) {
            throw threadContext.getRuntime().newArgumentError(iRubyObjectArray.length, 1);
        }
        if (!(iRubyObjectArray[0] instanceof XmlDocument)) {
            throw threadContext.getRuntime().newArgumentError("first parameter must be a Nokogiri::XML::Document instance");
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObjectArray[0];
        if (iRubyObjectArray.length > 1 && iRubyObjectArray[1] instanceof RubyString) {
            iRubyObjectArray[1] = XmlDocumentFragment.trim(threadContext, xmlDocument, (RubyString)iRubyObjectArray[1]);
            if (XmlDocumentFragment.isTag((RubyString)iRubyObjectArray[1])) {
                iRubyObjectArray[1] = RubyString.newString(threadContext.getRuntime(), XmlDocumentFragment.addNamespaceDeclIfNeeded(xmlDocument, NokogiriHelpers.rubyStringToString(iRubyObjectArray[1])));
            }
        }
        XmlDocumentFragment xmlDocumentFragment = (XmlDocumentFragment)NokogiriService.XML_DOCUMENT_FRAGMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlDocumentFragment.setDocument(threadContext, xmlDocument);
        xmlDocumentFragment.setNode(threadContext, xmlDocument.getDocument().createDocumentFragment());
        if (iRubyObjectArray.length == 3 && iRubyObjectArray[2] != null && iRubyObjectArray[2] instanceof XmlElement) {
            xmlDocumentFragment.fragmentContext = (XmlElement)iRubyObjectArray[2];
        }
        RuntimeHelpers.invoke(threadContext, (IRubyObject)xmlDocumentFragment, "initialize", iRubyObjectArray);
        return xmlDocumentFragment;
    }

    private static IRubyObject trim(ThreadContext threadContext, XmlDocument xmlDocument, RubyString rubyString) {
        Document document = (Document)xmlDocument.node;
        if (document.getDoctype() != null) {
            return rubyString;
        }
        IRubyObject iRubyObject = threadContext.getRuntime().is1_9() ? rubyString.chomp_bang19(threadContext) : rubyString.chomp_bang(threadContext);
        return iRubyObject.isNil() ? rubyString : iRubyObject;
    }

    private static boolean isTag(RubyString rubyString) {
        String string2 = NokogiriHelpers.rubyStringToString(rubyString);
        return string2.startsWith("<") && string2.endsWith(">");
    }

    private static boolean isNamespaceDefined(String string2, NamedNodeMap namedNodeMap) {
        if (NokogiriHelpers.isNamespace(string2.intern())) {
            return true;
        }
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Attr attr2 = (Attr)namedNodeMap.item(j);
            if (!NokogiriHelpers.isNamespace(attr2.getNodeName())) continue;
            String string3 = NokogiriHelpers.getLocalNameForNamespace(attr2.getNodeName());
            if (!NokogiriHelpers.getPrefix(string2).equals(string3)) continue;
            return true;
        }
        return false;
    }

    private static String addNamespaceDeclIfNeeded(XmlDocument xmlDocument, String string2) {
        String string3;
        Object object;
        Object object2;
        if (xmlDocument.getDocument() == null) {
            return string2;
        }
        if (xmlDocument.getDocument().getDocumentElement() == null) {
            return string2;
        }
        Matcher matcher = starttag_pattern.matcher(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (matcher.find()) {
            object2 = matcher.group();
            object = qname_pattern.matcher((CharSequence)object2);
            while (((Matcher)object).find()) {
                String string4;
                NamedNodeMap namedNodeMap;
                string3 = ((Matcher)object).group();
                if (!XmlDocumentFragment.isNamespaceDefined(string3, namedNodeMap = xmlDocument.getDocument().getDocumentElement().getAttributes()) || (string4 = XmlDocumentFragment.getNamespceDecl(NokogiriHelpers.getPrefix(string3), namedNodeMap)) == null) continue;
                hashMap.put("<" + string3 + ">", "<" + string3 + " " + string4 + ">");
            }
        }
        object2 = hashMap.keySet();
        object = object2.iterator();
        while (object.hasNext()) {
            string3 = (String)object.next();
            string2 = string2.replace(string3, (CharSequence)hashMap.get(string3));
        }
        return string2;
    }

    private static String getNamespceDecl(String string2, NamedNodeMap namedNodeMap) {
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Attr attr2 = (Attr)namedNodeMap.item(j);
            if (!string2.equals(attr2.getLocalName())) continue;
            return attr2.getName() + "=\"" + attr2.getValue() + "\"";
        }
        return null;
    }

    public XmlElement getFragmentContext() {
        return this.fragmentContext;
    }

    public void add_child(ThreadContext threadContext, XmlNode xmlNode) {
        Ruby ruby2 = threadContext.getRuntime();
        XmlNodeSet xmlNodeSet = (XmlNodeSet)xmlNode.children(threadContext);
        long l = xmlNodeSet.length();
        RubyArray rubyArray = xmlNodeSet.convertToArray();
        if (l != 0L) {
            int n = 0;
            while ((long)n < l) {
                XmlNode xmlNode2 = (XmlNode)((XmlNode)rubyArray.aref(ruby2.newFixnum(n))).dup_implementation(threadContext, true);
                this.add_child(threadContext, xmlNode2);
                ++n;
            }
        }
    }

    public void relink_namespace(ThreadContext threadContext) {
        ((XmlNodeSet)this.children(threadContext)).relink_namespace(threadContext);
    }
}

