/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nokogiri.NokogiriService;
import nokogiri.XmlComment;
import nokogiri.XmlDtd;
import nokogiri.XmlElement;
import nokogiri.XmlEntityDecl;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlProcessingInstruction;
import nokogiri.XmlText;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceCache;
import nokogiri.internals.SaveContextVisitor;
import nokogiri.internals.XmlDomParserContext;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNil;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::Document"}, parent="Nokogiri::XML::Node")
public class XmlDocument
extends XmlNode {
    private NokogiriNamespaceCache nsCache;
    public static final String DTD_RAW_DOCUMENT = "DTD_RAW_DOCUMENT";
    public static final String DTD_INTERNAL_SUBSET = "DTD_INTERNAL_SUBSET";
    public static final String DTD_EXTERNAL_SUBSET = "DTD_EXTERNAL_SUBSET";
    private static final String DOCUMENTBUILDERFACTORY_IMPLE_NAME = "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
    private static boolean substituteEntities = false;
    private static boolean loadExternalSubset = false;
    protected IRubyObject encoding = null;
    protected IRubyObject url = null;

    public XmlDocument(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass, XmlDocument.createNewDocument());
    }

    public XmlDocument(Ruby ruby2, Document document) {
        this(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Document"), document);
    }

    public XmlDocument(Ruby ruby2, RubyClass rubyClass, Document document) {
        super(ruby2, rubyClass, document);
        this.initializeNamespaceCacheIfNecessary();
        this.createAndCacheNamespaces(ruby2, document.getDocumentElement());
        this.stabilizeTextContent(document);
        this.setInstanceVariable("@decorators", ruby2.getNil());
    }

    public void setDocumentNode(ThreadContext threadContext, Node node) {
        super.setNode(threadContext, node);
        this.initializeNamespaceCacheIfNecessary();
        Ruby ruby2 = threadContext.getRuntime();
        if (node != null) {
            Document document = (Document)node;
            this.stabilizeTextContent(document);
            this.createAndCacheNamespaces(ruby2, document.getDocumentElement());
        }
        this.setInstanceVariable("@decorators", ruby2.getNil());
    }

    public void setEncoding(IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
    }

    public IRubyObject getEncoding() {
        return this.encoding;
    }

    protected void stabilizeTextContent(Document document) {
        if (document.getDocumentElement() != null) {
            document.getDocumentElement().getTextContent();
        }
    }

    private void createAndCacheNamespaces(Ruby ruby2, Node node) {
        int n;
        Object object;
        if (node == null) {
            return;
        }
        if (node.hasAttributes()) {
            object = node.getAttributes();
            for (n = 0; n < object.getLength(); ++n) {
                Node node2 = object.item(n);
                if (!(node2 instanceof Attr)) continue;
                Attr attr2 = (Attr)node2;
                String string2 = attr2.getName();
                String string3 = attr2.getValue();
                if (!NokogiriHelpers.isNamespace(string2)) continue;
                XmlNamespace.createFromAttr(ruby2, attr2);
            }
        }
        object = node.getChildNodes();
        for (n = 0; n < object.getLength(); ++n) {
            this.createAndCacheNamespaces(ruby2, object.item(n));
        }
    }

    public XmlDocument(Ruby ruby2, RubyClass rubyClass, Document document, XmlDocument xmlDocument) {
        super(ruby2, rubyClass, document);
        this.nsCache = xmlDocument.getNamespaceCache();
        XmlNamespace xmlNamespace = this.nsCache.getDefault();
        String string2 = NokogiriHelpers.rubyStringToString(xmlNamespace.href(ruby2.getCurrentContext()));
        this.resolveNamespaceIfNecessary(ruby2.getCurrentContext(), document.getDocumentElement(), string2);
    }

    private void resolveNamespaceIfNecessary(ThreadContext threadContext, Node node, String string2) {
        Object object;
        if (node == null) {
            return;
        }
        String string3 = node.getPrefix();
        if (string3 == null) {
            NokogiriHelpers.renameNode(node, string2, node.getNodeName());
        } else {
            object = this.nsCache.get(string3);
            String string4 = NokogiriHelpers.rubyStringToString(((XmlNamespace)object).href(threadContext));
            NokogiriHelpers.renameNode(node, string4, node.getNodeName());
        }
        this.resolveNamespaceIfNecessary(threadContext, node.getNextSibling(), string2);
        object = node.getChildNodes();
        for (int j = 0; j < object.getLength(); ++j) {
            this.resolveNamespaceIfNecessary(threadContext, object.item(j), string2);
        }
    }

    public NokogiriNamespaceCache getNamespaceCache() {
        return this.nsCache;
    }

    public void initializeNamespaceCacheIfNecessary() {
        if (this.nsCache == null) {
            this.nsCache = new NokogiriNamespaceCache();
        }
    }

    public void setNamespaceCache(NokogiriNamespaceCache nokogiriNamespaceCache) {
        this.nsCache = nokogiriNamespaceCache;
    }

    public Document getDocument() {
        return (Document)this.node;
    }

    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name == null) {
            this.name = threadContext.getRuntime().newString("document");
        }
        return this.name;
    }

    public void setUrl(IRubyObject iRubyObject) {
        this.url = iRubyObject;
    }

    protected IRubyObject getUrl() {
        return this.url;
    }

    @JRubyMethod
    public IRubyObject url(ThreadContext threadContext) {
        return this.getUrl();
    }

    public static Document createNewDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance(DOCUMENTBUILDERFACTORY_IMPLE_NAME, NokogiriService.class.getClassLoader());
            return documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true, required=0)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        XmlDocument xmlDocument = null;
        try {
            Document document = XmlDocument.createNewDocument();
            if ("Nokogiri::HTML::Document".equals(((RubyClass)iRubyObject).getName())) {
                xmlDocument = (XmlDocument)NokogiriService.HTML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
                xmlDocument.setDocumentNode(threadContext, document);
            } else {
                xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
                xmlDocument.setDocumentNode(threadContext, document);
            }
        }
        catch (Exception exception2) {
            throw threadContext.getRuntime().newRuntimeError("couldn't create document: " + exception2.toString());
        }
        RuntimeHelpers.invoke(threadContext, (IRubyObject)xmlDocument, "initialize", iRubyObjectArray);
        return xmlDocument;
    }

    @JRubyMethod(required=1, optional=4)
    public IRubyObject create_entity(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length == 0) {
            throw threadContext.getRuntime().newRuntimeError("Could not create entity");
        }
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObjectArray[0]);
        Element element = this.getOwnerDocument().createElement(string2);
        return XmlEntityDecl.create(threadContext, element, iRubyObjectArray);
    }

    @JRubyMethod
    public IRubyObject document(ThreadContext threadContext) {
        return this;
    }

    @JRubyMethod(name={"encoding="})
    public IRubyObject encoding_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.encoding = iRubyObject;
        return this;
    }

    @JRubyMethod
    public IRubyObject encoding(ThreadContext threadContext) {
        if (this.encoding == null || this.encoding.isNil()) {
            this.encoding = this.getDocument().getXmlEncoding() == null ? threadContext.getRuntime().getNil() : threadContext.getRuntime().newString(this.getDocument().getXmlEncoding());
        }
        return this.encoding.isNil() ? this.encoding : this.encoding.asString().encode(threadContext, threadContext.getRuntime().newString("UTF-8"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject load_external_subsets_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        loadExternalSubset = iRubyObject2.isTrue();
        return threadContext.getRuntime().getNil();
    }

    public static IRubyObject newFromData(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        Ruby ruby2 = threadContext.getRuntime();
        Arity.checkArgumentCount(ruby2, iRubyObjectArray, 4, 4);
        XmlDomParserContext xmlDomParserContext = new XmlDomParserContext(ruby2, iRubyObjectArray[2], iRubyObjectArray[3]);
        xmlDomParserContext.setInputSource(threadContext, iRubyObjectArray[0], iRubyObjectArray[1]);
        return xmlDomParserContext.parse(threadContext, iRubyObject, iRubyObjectArray[1]);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.newFromData(threadContext, iRubyObject, iRubyObjectArray);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.newFromData(threadContext, iRubyObject, iRubyObjectArray);
    }

    public static IRubyObject read_memory(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return XmlDocument.read_memory(threadContext, NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Document"), iRubyObjectArray);
    }

    @JRubyMethod(name={"remove_namespaces!"})
    public IRubyObject remove_namespaces(ThreadContext threadContext) {
        this.removeNamespceRecursively(threadContext, this);
        this.nsCache.clear();
        return this;
    }

    private void removeNamespceRecursively(ThreadContext threadContext, XmlNode xmlNode) {
        Object object;
        Node node = xmlNode.node;
        if (node.getNodeType() == 1) {
            node.setPrefix(null);
            NokogiriHelpers.renameNode(node, null, node.getLocalName());
            object = node.getAttributes();
            for (int j = 0; j < object.getLength(); ++j) {
                Attr attr2 = (Attr)object.item(j);
                if (NokogiriHelpers.isNamespace(attr2.getNodeName())) {
                    ((Element)node).removeAttributeNode(attr2);
                    continue;
                }
                attr2.setPrefix(null);
                NokogiriHelpers.renameNode(attr2, null, attr2.getLocalName());
            }
        }
        object = (XmlNodeSet)xmlNode.children(threadContext);
        for (long j = 0L; j < ((XmlNodeSet)object).length(); ++j) {
            XmlNode xmlNode2 = (XmlNode)((XmlNodeSet)object).slice(threadContext, RubyFixnum.newFixnum(threadContext.getRuntime(), j));
            this.removeNamespceRecursively(threadContext, xmlNode2);
        }
    }

    @JRubyMethod
    public IRubyObject root(ThreadContext threadContext) {
        Element element = this.getDocument().getDocumentElement();
        try {
            Boolean bl = (Boolean)element.getUserData("NOKOGIRI_VALIDE_ROOT_NODE");
            if (!bl.booleanValue()) {
                return threadContext.getRuntime().getNil();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (element == null) {
            return threadContext.getRuntime().getNil();
        }
        return NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), element);
    }

    @JRubyMethod(name={"root="})
    public IRubyObject root_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyNil) {
            this.getDocument().getDocumentElement().setUserData("NOKOGIRI_VALIDE_ROOT_NODE", false, null);
            return iRubyObject;
        }
        XmlNode xmlNode = XmlDocument.asXmlNode(threadContext, iRubyObject);
        IRubyObject iRubyObject2 = this.root(threadContext);
        if (iRubyObject2.isNil()) {
            Node node = this.getDocument() == xmlNode.getOwnerDocument() ? xmlNode.node : this.getDocument().importNode(xmlNode.node, true);
            this.add_child_node(threadContext, NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node));
        } else {
            Node node = XmlDocument.asXmlNode((ThreadContext)threadContext, (IRubyObject)iRubyObject2).node;
            ((XmlNode)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node)).replace_node(threadContext, xmlNode);
        }
        return xmlNode;
    }

    @JRubyMethod
    public IRubyObject version(ThreadContext threadContext) {
        return NokogiriHelpers.stringOrNil(threadContext.getRuntime(), this.getDocument().getXmlVersion());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject substitute_entities_set(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        substituteEntities = iRubyObject2.isTrue();
        return threadContext.getRuntime().getNil();
    }

    public IRubyObject getInternalSubset(ThreadContext threadContext) {
        IRubyObject iRubyObject = (IRubyObject)this.node.getUserData(DTD_INTERNAL_SUBSET);
        if (iRubyObject == null) {
            Document document = this.getDocument();
            if (document.getUserData(DTD_RAW_DOCUMENT) != null) {
                iRubyObject = XmlDtd.newFromInternalSubset(threadContext.getRuntime(), document);
            } else if (document.getDoctype() != null) {
                DocumentType documentType = document.getDoctype();
                iRubyObject = XmlDtd.newEmpty(threadContext.getRuntime(), document, threadContext.getRuntime().newString(documentType.getName()), threadContext.getRuntime().newString(documentType.getPublicId()), threadContext.getRuntime().newString(documentType.getSystemId()));
            } else {
                iRubyObject = threadContext.getRuntime().getNil();
            }
            this.setInternalSubset(iRubyObject);
        }
        return iRubyObject;
    }

    public IRubyObject createInternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setInternalSubset(xmlDtd);
        return xmlDtd;
    }

    protected void setInternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_INTERNAL_SUBSET, iRubyObject, null);
    }

    public IRubyObject getExternalSubset(ThreadContext threadContext) {
        IRubyObject iRubyObject = (IRubyObject)this.node.getUserData(DTD_EXTERNAL_SUBSET);
        if (iRubyObject == null) {
            return threadContext.getRuntime().getNil();
        }
        return iRubyObject;
    }

    public IRubyObject createExternalSubset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlDtd xmlDtd = XmlDtd.newEmpty(threadContext.getRuntime(), this.getDocument(), iRubyObject, iRubyObject2, iRubyObject3);
        this.setExternalSubset(xmlDtd);
        return xmlDtd;
    }

    protected void setExternalSubset(IRubyObject iRubyObject) {
        this.node.setUserData(DTD_EXTERNAL_SUBSET, iRubyObject, null);
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        Document document = this.getDocument();
        saveContextVisitor.enter(document);
        NodeList nodeList = document.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            XmlNode xmlNode;
            Node node = nodeList.item(j);
            short s2 = node.getNodeType();
            if (s2 == 8) {
                xmlNode = (XmlComment)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlComment)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s2 == 10) {
                xmlNode = (XmlDtd)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlDtd)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s2 == 7) {
                xmlNode = (XmlProcessingInstruction)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlProcessingInstruction)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s2 == 3) {
                xmlNode = (XmlText)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
                ((XmlText)xmlNode).accept(threadContext, saveContextVisitor);
                continue;
            }
            if (s2 != 1) continue;
            xmlNode = (XmlElement)NokogiriHelpers.getCachedNodeOrCreate(threadContext.getRuntime(), node);
            ((XmlElement)xmlNode).accept(threadContext, saveContextVisitor);
        }
        saveContextVisitor.leave(document);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject wrapJavaDocument(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlDocument xmlDocument = (XmlDocument)NokogiriService.XML_DOCUMENT_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::Document"));
        RuntimeHelpers.invoke(threadContext, xmlDocument, "initialize");
        Document document = (Document)iRubyObject2.toJava(Document.class);
        xmlDocument.setDocumentNode(threadContext, document);
        return xmlDocument;
    }

    @JRubyMethod
    public IRubyObject toJavaDocument(ThreadContext threadContext) {
        return JavaUtil.convertJavaToUsableRubyObject(threadContext.getRuntime(), (Document)this.node);
    }

    @JRubyMethod(optional=3)
    public IRubyObject canonicalize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        XmlNode xmlNode = this.getStartingNode(block);
        int n = 1;
        int n2 = 0;
        if (iRubyObjectArray.length == 3) {
            n2 = (Integer)(iRubyObjectArray[0].isNil() ? Integer.valueOf(0) : iRubyObjectArray[0].toJava(Integer.class));
            if (n2 == 1) {
                n |= 0x10;
            }
            int n3 = n = iRubyObjectArray[2].isTrue() ? n | 4 : n;
        }
        if (xmlNode != this) {
            n |= 8;
        }
        SaveContextVisitor saveContextVisitor = new SaveContextVisitor(38, null, "UTF-8", false, false, n);
        if (iRubyObjectArray.length == 3 && !iRubyObjectArray[1].isNil()) {
            saveContextVisitor.setC14nExclusiveInclusivePrefixes(NokogiriHelpers.rubyStringArrayToJavaList((RubyArray)iRubyObjectArray[1]));
        }
        xmlNode.accept(threadContext, saveContextVisitor);
        Ruby ruby2 = threadContext.getRuntime();
        IRubyObject iRubyObject = ruby2.getTrue();
        if (block.isGiven()) {
            List<Node> list2 = saveContextVisitor.getC14nNodeList();
            for (Node node : list2) {
                IRubyObject iRubyObject2 = NokogiriHelpers.getCachedNodeOrCreate(ruby2, node);
                IRubyObject iRubyObject3 = NokogiriHelpers.getCachedNodeOrCreate(ruby2, node.getParentNode());
                iRubyObject = block.call(threadContext, iRubyObject2, iRubyObject3);
            }
        }
        return iRubyObject.isTrue() ? NokogiriHelpers.stringOrNil(ruby2, saveContextVisitor.toString()) : RubyString.newEmptyString(ruby2);
    }

    private XmlNode getStartingNode(Block block) {
        if (block.isGiven() && block.getBinding().getSelf() instanceof XmlNode) {
            return (XmlNode)block.getBinding().getSelf();
        }
        return this;
    }
}

