/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.HtmlDocument;
import nokogiri.XmlDocument;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::Attr"}, parent="Nokogiri::XML::Node")
public class XmlAttr
extends XmlNode {
    public static final String[] HTML_BOOLEAN_ATTRS = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};

    public XmlAttr(Ruby ruby2, Node node) {
        super(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Attr"), node);
    }

    public XmlAttr(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public XmlAttr(Ruby ruby2, RubyClass rubyClass, Node node) {
        super(ruby2, rubyClass, node);
    }

    protected void init(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        if (iRubyObjectArray.length < 2) {
            throw this.getRuntime().newArgumentError(iRubyObjectArray.length, 2);
        }
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        if (!(iRubyObject instanceof XmlDocument)) {
            throw this.getRuntime().newArgumentError("document must be an instance of Nokogiri::XML::Document");
        }
        XmlDocument xmlDocument = (XmlDocument)iRubyObject;
        String string2 = NokogiriHelpers.rubyStringToString(iRubyObject2);
        Attr attr2 = xmlDocument.getDocument().createAttribute(string2);
        this.setNode(threadContext, attr2);
    }

    void setNamespaceIfNecessary(Ruby ruby2) {
        if ("xml".equals(this.node.getPrefix())) {
            XmlNamespace.createDefaultNamespace(ruby2, this.node);
        }
    }

    private boolean isHtmlBooleanAttr() {
        String string2 = this.node.getNodeName().toLowerCase();
        for (String string3 : HTML_BOOLEAN_ATTRS) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private String serializeAttrTextContent(String string2, boolean bl) {
        if (string2 == null) {
            return "";
        }
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        block9: for (int j = 0; j < cArray.length; ++j) {
            switch (cArray[j]) {
                case '\n': {
                    stringBuffer.append("&#10;");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("&#13;");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("&#9;");
                    continue block9;
                }
                case '\"': {
                    if (bl) {
                        stringBuffer.append("%22");
                        continue block9;
                    }
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[j]);
                }
            }
        }
        return stringBuffer.toString();
    }

    @JRubyMethod(name={"content", "value", "to_s"})
    public IRubyObject content(ThreadContext threadContext) {
        if (this.content != null && !this.content.isNil()) {
            return this.content;
        }
        if (this.node == null) {
            return threadContext.getRuntime().getNil();
        }
        String string2 = ((Attr)this.node).getValue();
        if (string2 == null) {
            return threadContext.getRuntime().getNil();
        }
        return RubyString.newString(threadContext.getRuntime(), string2);
    }

    @JRubyMethod(name={"value=", "content="})
    public IRubyObject value_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        Attr attr2 = (Attr)this.node;
        attr2.setValue(NokogiriHelpers.rubyStringToString(XmlNode.encode_special_chars(threadContext, iRubyObject)));
        this.setContent(iRubyObject);
        return iRubyObject;
    }

    protected IRubyObject getNodeName(ThreadContext threadContext) {
        if (this.name != null) {
            return this.name;
        }
        String string2 = ((Attr)this.node).getName();
        if (!(this.doc instanceof HtmlDocument)) {
            string2 = NokogiriHelpers.getLocalPart(string2);
        }
        return string2 == null ? threadContext.getRuntime().getNil() : RubyString.newString(threadContext.getRuntime(), string2);
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        saveContextVisitor.enter((Attr)this.node);
        saveContextVisitor.leave((Attr)this.node);
    }

    private boolean isHtml(ThreadContext threadContext) {
        return this.document(threadContext).getMetaClass().isKindOfModule(NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::HTML::Document"));
    }

    public IRubyObject unlink(ThreadContext threadContext) {
        Attr attr2 = (Attr)this.node;
        Element element = attr2.getOwnerElement();
        element.removeAttributeNode(attr2);
        return this;
    }
}

