/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.NokogiriService;
import nokogiri.XmlSaxParserContext;
import nokogiri.internals.NokogiriHandler;
import nokogiri.internals.NokogiriHelpers;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.cyberneko.html.parsers.SAXParser;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.SAXException;

@JRubyClass(name={"Nokogiri::HTML::SAX::ParserContext"}, parent="Nokogiri::XML::SAX::ParserContext")
public class HtmlSaxParserContext
extends XmlSaxParserContext {
    public HtmlSaxParserContext(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    protected AbstractSAXParser createParser() throws SAXException {
        SAXParser sAXParser = new SAXParser();
        try {
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
            sAXParser.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
            return sAXParser;
        }
        catch (SAXException sAXException) {
            throw new SAXException("Problem while creating HTML SAX Parser: " + sAXException.toString());
        }
    }

    @JRubyMethod(name={"memory"}, meta=true)
    public static IRubyObject parse_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        String string2 = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string2 != null) {
            String string3 = HtmlSaxParserContext.applyEncoding(NokogiriHelpers.rubyStringToString(iRubyObject2), string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
            htmlSaxParserContext.setInputSource(byteArrayInputStream);
            htmlSaxParserContext.getInputSource().setEncoding(string2);
        }
        return htmlSaxParserContext;
    }

    private static String findName(int n) {
        EnumSet<EncodingType> enumSet = EnumSet.allOf(EncodingType.class);
        for (EncodingType encodingType : enumSet) {
            if (encodingType.getValue() != n) continue;
            return encodingType.toString();
        }
        return null;
    }

    private static String findEncoding(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string2 = null;
        if (iRubyObject instanceof RubyString) {
            string2 = NokogiriHelpers.rubyStringToString(iRubyObject);
        } else if (iRubyObject instanceof RubyFixnum) {
            int n = (Integer)iRubyObject.toJava(Integer.class);
            string2 = HtmlSaxParserContext.findName(n);
        }
        if (string2 == null) {
            return null;
        }
        try {
            Charset charset = Charset.forName(string2);
            return charset.displayName();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw threadContext.getRuntime().newEncodingCompatibilityError(string2 + "is not supported in Java.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw threadContext.getRuntime().newInvalidEncoding("encoding should not be nil");
        }
    }

    private static String applyEncoding(String string2, String string3) {
        Object object;
        String string4 = string2.toLowerCase();
        int n = 0;
        int n2 = 0;
        if (string2.contains("meta") && string2.contains("charset")) {
            object = Pattern.compile("charset(()|\\s)=(()|\\s)([a-z]|-|_|\\d)+");
            Matcher matcher = ((Pattern)object).matcher(string4);
            while (matcher.find()) {
                n = matcher.start();
                n2 = matcher.end();
            }
        }
        if (n != n2) {
            object = string2.substring(n, n2);
            string2 = string2.replace((CharSequence)object, "charset=" + string3);
        }
        return string2;
    }

    @JRubyMethod(name={"file"}, meta=true)
    public static IRubyObject parse_file(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        htmlSaxParserContext.setInputSourceFile(threadContext, iRubyObject2);
        String string2 = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string2 != null) {
            htmlSaxParserContext.getInputSource().setEncoding(string2);
        }
        return htmlSaxParserContext;
    }

    @JRubyMethod(name={"io"}, meta=true)
    public static IRubyObject parse_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        htmlSaxParserContext.setInputSource(threadContext, iRubyObject2, threadContext.getRuntime().getNil());
        String string2 = HtmlSaxParserContext.findEncoding(threadContext, iRubyObject3);
        if (string2 != null) {
            htmlSaxParserContext.getInputSource().setEncoding(string2);
        }
        return htmlSaxParserContext;
    }

    public static IRubyObject parse_stream(ThreadContext threadContext, IRubyObject iRubyObject, InputStream inputStream) {
        HtmlSaxParserContext htmlSaxParserContext = (HtmlSaxParserContext)NokogiriService.HTML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlSaxParserContext.initialize(threadContext.getRuntime());
        htmlSaxParserContext.setInputSource(inputStream);
        return htmlSaxParserContext;
    }

    protected void preParse(ThreadContext threadContext, IRubyObject iRubyObject, NokogiriHandler nokogiriHandler) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncodingType {
        NONE(0, "NONE"),
        UTF_8(1, "UTF-8"),
        UTF16LE(2, "UTF16LE"),
        UTF16BE(3, "UTF16BE"),
        UCS4LE(4, "UCS4LE"),
        UCS4BE(5, "UCS4BE"),
        EBCDIC(6, "EBCDIC"),
        UCS4_2143(7, "ICS4-2143"),
        UCS4_3412(8, "UCS4-3412"),
        UCS2(9, "UCS2"),
        ISO_8859_1(10, "ISO-8859-1"),
        ISO_8859_2(11, "ISO-8859-2"),
        ISO_8859_3(12, "ISO-8859-3"),
        ISO_8859_4(13, "ISO-8859-4"),
        ISO_8859_5(14, "ISO-8859-5"),
        ISO_8859_6(15, "ISO-8859-6"),
        ISO_8859_7(16, "ISO-8859-7"),
        ISO_8859_8(17, "ISO-8859-8"),
        ISO_8859_9(18, "ISO-8859-9"),
        ISO_2022_JP(19, "ISO-2022-JP"),
        SHIFT_JIS(20, "SHIFT-JIS"),
        EUC_JP(21, "EUC-JP"),
        ASCII(22, "ASCII");

        private final int value;
        private final String name;

        private EncodingType(int n2, String string3) {
            this.value = n2;
            this.name = string3;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }
    }
}

