/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cyberneko.html.HTMLElements;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Nokogiri::HTML::ElementDescription"})
public class HtmlElementDescription
extends RubyObject {
    protected static Map<Short, List<String>> subElements;
    protected HTMLElements.Element element;

    public HtmlElementDescription(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    protected static List<String> findSubElements(HTMLElements.Element element) {
        List<String> list2 = subElements.get(element.code);
        if (list2 == null) {
            list2 = new ArrayList<String>();
            for (short s2 = 0; s2 < 117; s2 = (short)(s2 + 1)) {
                HTMLElements.Element element2 = HTMLElements.getElement(s2);
                if (!element2.isParent(element)) continue;
                list2.add(element2.name);
            }
            subElements.put(element.code, list2);
        }
        return list2;
    }

    @JRubyMethod(name={"[]"}, meta=true)
    public static IRubyObject get(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        HTMLElements.Element element = HTMLElements.getElement(iRubyObject2.toString());
        if (element == HTMLElements.NO_SUCH_ELEMENT) {
            return threadContext.getRuntime().getNil();
        }
        HtmlElementDescription htmlElementDescription = new HtmlElementDescription(threadContext.getRuntime(), (RubyClass)iRubyObject);
        htmlElementDescription.element = element;
        return htmlElementDescription;
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.element.name.toLowerCase());
    }

    @JRubyMethod(name={"inline?"})
    public IRubyObject inline_eh(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.element.isInline());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_eh(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.element.isEmpty());
    }

    @JRubyMethod
    public IRubyObject sub_elements(ThreadContext threadContext) {
        Ruby ruby2 = threadContext.getRuntime();
        List<String> list2 = HtmlElementDescription.findSubElements(this.element);
        IRubyObject[] iRubyObjectArray = new IRubyObject[list2.size()];
        for (int j = 0; j < list2.size(); ++j) {
            iRubyObjectArray[j] = ruby2.newString(list2.get(j));
        }
        return ruby2.newArray(iRubyObjectArray);
    }

    static {
        HashMap hashMap = new HashMap();
        subElements = Collections.synchronizedMap(hashMap);
    }
}

