/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.RuntimeInfo;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

final class OptionsReader {
    private final ThreadContext context;
    private final Ruby runtime;
    private final RubyHash opts;
    private RuntimeInfo info;

    OptionsReader(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.context = threadContext;
        this.runtime = threadContext.getRuntime();
        this.opts = iRubyObject == null || iRubyObject.isNil() ? null : (iRubyObject.respondsTo("to_hash") ? iRubyObject.convertToHash() : (iRubyObject.respondsTo("to_h") ? iRubyObject.callMethod(threadContext, "to_h").convertToHash() : iRubyObject.convertToHash()));
    }

    private RuntimeInfo getRuntimeInfo() {
        if (this.info != null) {
            return this.info;
        }
        this.info = RuntimeInfo.forRuntime(this.runtime);
        return this.info;
    }

    IRubyObject get(String string2) {
        return this.opts == null ? null : this.opts.fastARef(this.runtime.newSymbol(string2));
    }

    boolean getBool(String string2, boolean bl) {
        IRubyObject iRubyObject = this.get(string2);
        return iRubyObject == null ? bl : iRubyObject.isTrue();
    }

    int getInt(String string2, int n) {
        IRubyObject iRubyObject = this.get(string2);
        if (iRubyObject == null) {
            return n;
        }
        if (!iRubyObject.isTrue()) {
            return 0;
        }
        return RubyNumeric.fix2int(iRubyObject);
    }

    ByteList getString(String string2) {
        RubyString rubyString = this.getString(string2, null);
        return rubyString == null ? null : rubyString.getByteList().dup();
    }

    RubyString getString(String string2, RubyString rubyString) {
        IRubyObject iRubyObject = this.get(string2);
        if (iRubyObject == null || !iRubyObject.isTrue()) {
            return rubyString;
        }
        RubyString rubyString2 = iRubyObject.convertToString();
        RuntimeInfo runtimeInfo = this.getRuntimeInfo();
        if (runtimeInfo.encodingsSupported() && rubyString2.encoding(this.context) != runtimeInfo.utf8.get()) {
            rubyString2 = (RubyString)rubyString2.encode(this.context, (IRubyObject)runtimeInfo.utf8.get());
        }
        return rubyString2;
    }

    RubyClass getClass(String string2, RubyClass rubyClass) {
        IRubyObject iRubyObject = this.get(string2);
        if (iRubyObject == null || iRubyObject.isNil()) {
            return rubyClass;
        }
        return (RubyClass)iRubyObject;
    }

    public RubyHash getHash(String string2) {
        IRubyObject iRubyObject = this.get(string2);
        if (iRubyObject == null || iRubyObject.isNil()) {
            return new RubyHash(this.runtime);
        }
        return (RubyHash)iRubyObject;
    }
}

