/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket.example;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixServerSocket;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class UnixServer {
    public static void main(String[] args2) throws IOException {
        File path2 = new File("/tmp/fubar.sock");
        path2.deleteOnExit();
        UnixSocketAddress address2 = new UnixSocketAddress(path2);
        UnixServerSocketChannel channel = UnixServerSocketChannel.open();
        try {
            AbstractSelector sel = NativeSelectorProvider.getInstance().openSelector();
            channel.configureBlocking(false);
            channel.socket().bind(address2);
            channel.register(sel, 16, new ServerActor(channel, sel));
            while (sel.select() > 0) {
                Set<SelectionKey> keys2 = sel.selectedKeys();
                for (SelectionKey k : keys2) {
                    Actor a = (Actor)k.attachment();
                    if (a.rxready()) continue;
                    k.cancel();
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(UnixServerSocket.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static final class ClientActor
    implements Actor {
        private final UnixSocketChannel channel;

        public ClientActor(UnixSocketChannel channel) {
            this.channel = channel;
        }

        public final boolean rxready() {
            try {
                ByteBuffer buf = ByteBuffer.allocate(1024);
                int n = this.channel.read(buf);
                UnixSocketAddress remote = this.channel.getRemoteSocketAddress();
                System.out.printf("Read in %d bytes from %s\n", n, remote);
                if (n > 0) {
                    buf.flip();
                    this.channel.write(buf);
                    return true;
                }
                if (n < 0) {
                    return false;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
    }

    static final class ServerActor
    implements Actor {
        private final UnixServerSocketChannel channel;
        private final Selector selector;

        public ServerActor(UnixServerSocketChannel channel, Selector selector) {
            this.channel = channel;
            this.selector = selector;
        }

        public final boolean rxready() {
            try {
                UnixSocketChannel client = this.channel.accept();
                client.configureBlocking(false);
                client.register(this.selector, 1, new ClientActor(client));
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
    }

    static interface Actor {
        public boolean rxready();
    }
}

