/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import java.util.concurrent.atomic.AtomicBoolean;
import jnr.ffi.Runtime;
import jnr.ffi.provider.jffi.DirectMemoryIO;
import jnr.ffi.provider.jffi.NativeRuntime;

class AllocatedDirectMemoryIO
extends DirectMemoryIO {
    private final AtomicBoolean allocated = new AtomicBoolean(true);
    private final int size;

    public AllocatedDirectMemoryIO(Runtime runtime, int size2, boolean clear2) {
        super(runtime, IO.allocateMemory(size2, clear2));
        this.size = size2;
        if (this.address == 0L) {
            throw new OutOfMemoryError("Failed to allocate " + size2 + " bytes");
        }
    }

    public AllocatedDirectMemoryIO(int size2, boolean clear2) {
        this(NativeRuntime.getInstance(), size2, clear2);
    }

    public long size() {
        return this.size;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AllocatedDirectMemoryIO) {
            AllocatedDirectMemoryIO mem = (AllocatedDirectMemoryIO)obj;
            return mem.size == this.size && mem.address() == this.address;
        }
        return super.equals(obj);
    }

    public String toString() {
        return String.format(this.getClass().getName() + " address=%x size=%d", this.address, this.size());
    }

    public final void dispose() {
        if (this.allocated.getAndSet(false)) {
            IO.freeMemory(this.address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.allocated.getAndSet(false)) {
                IO.freeMemory(this.address);
            }
        }
        finally {
            super.finalize();
        }
    }
}

