/*
 * Decompiled with CFR 0.152.
 */
package javassist.convert;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.convert.Transformer;

public class TransformReadField
extends Transformer {
    protected String fieldname;
    protected CtClass fieldClass;
    protected boolean isPrivate;
    protected String methodClassname;
    protected String methodName;

    public TransformReadField(Transformer next, CtField field2, String methodClassname, String methodName) {
        super(next);
        this.fieldClass = field2.getDeclaringClass();
        this.fieldname = field2.getName();
        this.methodClassname = methodClassname;
        this.methodName = methodName;
        this.isPrivate = Modifier.isPrivate(field2.getModifiers());
    }

    static String isField(ClassPool pool, ConstPool cp, CtClass fclass, String fname, boolean is_private, int index2) {
        if (!cp.getFieldrefName(index2).equals(fname)) {
            return null;
        }
        try {
            CtClass c = pool.get(cp.getFieldrefClassName(index2));
            if (c == fclass || !is_private && TransformReadField.isFieldInSuper(c, fclass, fname)) {
                return cp.getFieldrefType(index2);
            }
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        return null;
    }

    static boolean isFieldInSuper(CtClass clazz, CtClass fclass, String fname) {
        if (!clazz.subclassOf(fclass)) {
            return false;
        }
        try {
            CtField f = clazz.getField(fname);
            return f.getDeclaringClass() == fclass;
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public int transform(CtClass tclazz, int pos2, CodeIterator iterator, ConstPool cp) throws BadBytecode {
        int c = iterator.byteAt(pos2);
        if (c == 180 || c == 178) {
            int index2 = iterator.u16bitAt(pos2 + 1);
            String typedesc = TransformReadField.isField(tclazz.getClassPool(), cp, this.fieldClass, this.fieldname, this.isPrivate, index2);
            if (typedesc != null) {
                if (c == 178) {
                    iterator.move(pos2);
                    pos2 = iterator.insertGap(1);
                    iterator.writeByte(1, pos2);
                    pos2 = iterator.next();
                }
                String type2 = "(Ljava/lang/Object;)" + typedesc;
                int mi = cp.addClassInfo(this.methodClassname);
                int methodref = cp.addMethodrefInfo(mi, this.methodName, type2);
                iterator.writeByte(184, pos2);
                iterator.write16bit(methodref, pos2 + 1);
                return pos2;
            }
        }
        return pos2;
    }
}

