/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.annotation;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.AnnotationImpl;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.AnnotationsWriter;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.NoSuchClassError;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class Annotation {
    ConstPool pool;
    int typeIndex;
    LinkedHashMap members;

    public Annotation(int type2, ConstPool cp) {
        this.pool = cp;
        this.typeIndex = type2;
        this.members = null;
    }

    public Annotation(String typeName, ConstPool cp) {
        this(cp.addUtf8Info(Descriptor.of(typeName)), cp);
    }

    public Annotation(ConstPool cp, CtClass clazz) throws NotFoundException {
        this(cp.addUtf8Info(Descriptor.of(clazz.getName())), cp);
        if (!clazz.isInterface()) {
            throw new RuntimeException("Only interfaces are allowed for Annotation creation.");
        }
        CtMethod[] methods2 = clazz.getDeclaredMethods();
        if (methods2.length > 0) {
            this.members = new LinkedHashMap();
        }
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            CtClass returnType = methods2[i2].getReturnType();
            this.addMemberValue(methods2[i2].getName(), Annotation.createMemberValue(cp, returnType));
        }
    }

    public static MemberValue createMemberValue(ConstPool cp, CtClass type2) throws NotFoundException {
        if (type2 == CtClass.booleanType) {
            return new BooleanMemberValue(cp);
        }
        if (type2 == CtClass.byteType) {
            return new ByteMemberValue(cp);
        }
        if (type2 == CtClass.charType) {
            return new CharMemberValue(cp);
        }
        if (type2 == CtClass.shortType) {
            return new ShortMemberValue(cp);
        }
        if (type2 == CtClass.intType) {
            return new IntegerMemberValue(cp);
        }
        if (type2 == CtClass.longType) {
            return new LongMemberValue(cp);
        }
        if (type2 == CtClass.floatType) {
            return new FloatMemberValue(cp);
        }
        if (type2 == CtClass.doubleType) {
            return new DoubleMemberValue(cp);
        }
        if (type2.getName().equals("java.lang.Class")) {
            return new ClassMemberValue(cp);
        }
        if (type2.getName().equals("java.lang.String")) {
            return new StringMemberValue(cp);
        }
        if (type2.isArray()) {
            CtClass arrayType = type2.getComponentType();
            MemberValue member = Annotation.createMemberValue(cp, arrayType);
            return new ArrayMemberValue(member, cp);
        }
        if (type2.isInterface()) {
            Annotation info = new Annotation(cp, type2);
            return new AnnotationMemberValue(info, cp);
        }
        EnumMemberValue emv = new EnumMemberValue(cp);
        emv.setType(type2.getName());
        return emv;
    }

    public void addMemberValue(int nameIndex, MemberValue value2) {
        Pair p2 = new Pair();
        p2.name = nameIndex;
        p2.value = value2;
        this.addMemberValue(p2);
    }

    public void addMemberValue(String name2, MemberValue value2) {
        Pair p2 = new Pair();
        p2.name = this.pool.addUtf8Info(name2);
        p2.value = value2;
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(name2, p2);
    }

    private void addMemberValue(Pair pair) {
        String name2 = this.pool.getUtf8Info(pair.name);
        if (this.members == null) {
            this.members = new LinkedHashMap();
        }
        this.members.put(name2, pair);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("@");
        buf.append(this.getTypeName());
        if (this.members != null) {
            buf.append("(");
            Iterator mit = this.members.keySet().iterator();
            while (mit.hasNext()) {
                String name2 = (String)mit.next();
                buf.append(name2).append("=").append(this.getMemberValue(name2));
                if (!mit.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String getTypeName() {
        return Descriptor.toClassName(this.pool.getUtf8Info(this.typeIndex));
    }

    public Set getMemberNames() {
        if (this.members == null) {
            return null;
        }
        return this.members.keySet();
    }

    public MemberValue getMemberValue(String name2) {
        if (this.members == null) {
            return null;
        }
        Pair p2 = (Pair)this.members.get(name2);
        if (p2 == null) {
            return null;
        }
        return p2.value;
    }

    public Object toAnnotationType(ClassLoader cl, ClassPool cp) throws ClassNotFoundException, NoSuchClassError {
        return AnnotationImpl.make(cl, MemberValue.loadClass(cl, this.getTypeName()), cp, this);
    }

    public void write(AnnotationsWriter writer) throws IOException {
        String typeName = this.pool.getUtf8Info(this.typeIndex);
        if (this.members == null) {
            writer.annotation(typeName, 0);
            return;
        }
        writer.annotation(typeName, this.members.size());
        Iterator it = this.members.values().iterator();
        while (it.hasNext()) {
            Pair pair = (Pair)it.next();
            writer.memberValuePair(pair.name);
            pair.value.write(writer);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        LinkedHashMap otherMembers = other.members;
        if (this.members == otherMembers) {
            return true;
        }
        if (this.members == null) {
            return otherMembers == null;
        }
        if (otherMembers == null) {
            return false;
        }
        return this.members.equals(otherMembers);
    }

    static class Pair {
        int name;
        MemberValue value;

        Pair() {
        }
    }
}

