/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Opcode;
import javassist.bytecode.analysis.Subroutine;
import javassist.bytecode.analysis.Util;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map subTable = new HashMap();
    Set done = new HashSet();

    public Subroutine[] scan(MethodInfo method2) throws BadBytecode {
        CodeAttribute code = method2.getCodeAttribute();
        CodeIterator iter = code.iterator();
        this.subroutines = new Subroutine[code.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, iter, null);
        ExceptionTable exceptions = code.getExceptionTable();
        for (int i2 = 0; i2 < exceptions.size(); ++i2) {
            int handler = exceptions.handlerPc(i2);
            this.scan(handler, iter, this.subroutines[exceptions.startPc(i2)]);
        }
        return this.subroutines;
    }

    private void scan(int pos2, CodeIterator iter, Subroutine sub3) throws BadBytecode {
        boolean next;
        if (this.done.contains(new Integer(pos2))) {
            return;
        }
        this.done.add(new Integer(pos2));
        int old = iter.lookAhead();
        iter.move(pos2);
        while (next = this.scanOp(pos2 = iter.next(), iter, sub3) && iter.hasNext()) {
        }
        iter.move(old);
    }

    private boolean scanOp(int pos2, CodeIterator iter, Subroutine sub3) throws BadBytecode {
        this.subroutines[pos2] = sub3;
        int opcode = iter.byteAt(pos2);
        if (opcode == 170) {
            this.scanTableSwitch(pos2, iter, sub3);
            return false;
        }
        if (opcode == 171) {
            this.scanLookupSwitch(pos2, iter, sub3);
            return false;
        }
        if (Util.isReturn(opcode) || opcode == 169 || opcode == 191) {
            return false;
        }
        if (Util.isJumpInstruction(opcode)) {
            int target = Util.getJumpTarget(pos2, iter);
            if (opcode == 168 || opcode == 201) {
                Subroutine s2 = (Subroutine)this.subTable.get(new Integer(target));
                if (s2 == null) {
                    s2 = new Subroutine(target, pos2);
                    this.subTable.put(new Integer(target), s2);
                    this.scan(target, iter, s2);
                } else {
                    s2.addCaller(pos2);
                }
            } else {
                this.scan(target, iter, sub3);
                if (Util.isGoto(opcode)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int pos2, CodeIterator iter, Subroutine sub3) throws BadBytecode {
        int index2 = (pos2 & 0xFFFFFFFC) + 4;
        this.scan(pos2 + iter.s32bitAt(index2), iter, sub3);
        int npairs = iter.s32bitAt(index2 += 4);
        int end2 = npairs * 8 + (index2 += 4);
        index2 += 4;
        while (index2 < end2) {
            int target = iter.s32bitAt(index2) + pos2;
            this.scan(target, iter, sub3);
            index2 += 8;
        }
    }

    private void scanTableSwitch(int pos2, CodeIterator iter, Subroutine sub3) throws BadBytecode {
        int index2 = (pos2 & 0xFFFFFFFC) + 4;
        this.scan(pos2 + iter.s32bitAt(index2), iter, sub3);
        int low = iter.s32bitAt(index2 += 4);
        int high = iter.s32bitAt(index2 += 4);
        int end2 = (high - low + 1) * 4 + (index2 += 4);
        while (index2 < end2) {
            int target = iter.s32bitAt(index2) + pos2;
            this.scan(target, iter, sub3);
            index2 += 4;
        }
    }
}

