/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javassist.bytecode.ConstInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

class NameAndTypeInfo
extends ConstInfo {
    static final int tag = 12;
    int memberName;
    int typeDescriptor;

    public NameAndTypeInfo(int name2, int type2) {
        this.memberName = name2;
        this.typeDescriptor = type2;
    }

    public NameAndTypeInfo(DataInputStream in) throws IOException {
        this.memberName = in.readUnsignedShort();
        this.typeDescriptor = in.readUnsignedShort();
    }

    boolean hashCheck(int a, int b) {
        return a == this.memberName && b == this.typeDescriptor;
    }

    public int getTag() {
        return 12;
    }

    public void renameClass(ConstPool cp, String oldName, String newName) {
        String type2;
        String type3 = cp.getUtf8Info(this.typeDescriptor);
        if (type3 != (type2 = Descriptor.rename(type3, oldName, newName))) {
            this.typeDescriptor = cp.addUtf8Info(type2);
        }
    }

    public void renameClass(ConstPool cp, Map map) {
        String type2;
        String type3 = cp.getUtf8Info(this.typeDescriptor);
        if (type3 != (type2 = Descriptor.rename(type3, map))) {
            this.typeDescriptor = cp.addUtf8Info(type2);
        }
    }

    public int copy(ConstPool src, ConstPool dest, Map map) {
        String mname = src.getUtf8Info(this.memberName);
        String tdesc = src.getUtf8Info(this.typeDescriptor);
        tdesc = Descriptor.rename(tdesc, map);
        return dest.addNameAndTypeInfo(dest.addUtf8Info(mname), dest.addUtf8Info(tdesc));
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(12);
        out.writeShort(this.memberName);
        out.writeShort(this.typeDescriptor);
    }

    public void print(PrintWriter out) {
        out.print("NameAndType #");
        out.print(this.memberName);
        out.print(", type #");
        out.println(this.typeDescriptor);
    }
}

