/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;

public class LocalVariableAttribute
extends AttributeInfo {
    public static final String tag = "LocalVariableTable";
    public static final String typeTag = "LocalVariableTypeTable";

    public LocalVariableAttribute(ConstPool cp) {
        super(cp, tag, new byte[2]);
        ByteArray.write16bit(0, this.info, 0);
    }

    public LocalVariableAttribute(ConstPool cp, String name2) {
        super(cp, name2, new byte[2]);
        ByteArray.write16bit(0, this.info, 0);
    }

    LocalVariableAttribute(ConstPool cp, int n, DataInputStream in) throws IOException {
        super(cp, n, in);
    }

    LocalVariableAttribute(ConstPool cp, String name2, byte[] i2) {
        super(cp, name2, i2);
    }

    public void addEntry(int startPc, int length2, int nameIndex, int descriptorIndex, int index2) {
        int size2 = this.info.length;
        byte[] newInfo = new byte[size2 + 10];
        ByteArray.write16bit(this.tableLength() + 1, newInfo, 0);
        for (int i2 = 2; i2 < size2; ++i2) {
            newInfo[i2] = this.info[i2];
        }
        ByteArray.write16bit(startPc, newInfo, size2);
        ByteArray.write16bit(length2, newInfo, size2 + 2);
        ByteArray.write16bit(nameIndex, newInfo, size2 + 4);
        ByteArray.write16bit(descriptorIndex, newInfo, size2 + 6);
        ByteArray.write16bit(index2, newInfo, size2 + 8);
        this.info = newInfo;
    }

    void renameClass(String oldname, String newname) {
        ConstPool cp = this.getConstPool();
        int n = this.tableLength();
        for (int i2 = 0; i2 < n; ++i2) {
            int pos2 = i2 * 10 + 2;
            int index2 = ByteArray.readU16bit(this.info, pos2 + 6);
            if (index2 == 0) continue;
            String desc = cp.getUtf8Info(index2);
            desc = this.renameEntry(desc, oldname, newname);
            ByteArray.write16bit(cp.addUtf8Info(desc), this.info, pos2 + 6);
        }
    }

    String renameEntry(String desc, String oldname, String newname) {
        return Descriptor.rename(desc, oldname, newname);
    }

    void renameClass(Map classnames) {
        ConstPool cp = this.getConstPool();
        int n = this.tableLength();
        for (int i2 = 0; i2 < n; ++i2) {
            int pos2 = i2 * 10 + 2;
            int index2 = ByteArray.readU16bit(this.info, pos2 + 6);
            if (index2 == 0) continue;
            String desc = cp.getUtf8Info(index2);
            desc = this.renameEntry(desc, classnames);
            ByteArray.write16bit(cp.addUtf8Info(desc), this.info, pos2 + 6);
        }
    }

    String renameEntry(String desc, Map classnames) {
        return Descriptor.rename(desc, classnames);
    }

    public void shiftIndex(int lessThan, int delta) {
        int size2 = this.info.length;
        for (int i2 = 2; i2 < size2; i2 += 10) {
            int org2 = ByteArray.readU16bit(this.info, i2 + 8);
            if (org2 < lessThan) continue;
            ByteArray.write16bit(org2 + delta, this.info, i2 + 8);
        }
    }

    public int tableLength() {
        return ByteArray.readU16bit(this.info, 0);
    }

    public int startPc(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 2);
    }

    public int codeLength(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 4);
    }

    void shiftPc(int where, int gapLength, boolean exclusive2) {
        int n = this.tableLength();
        for (int i2 = 0; i2 < n; ++i2) {
            int pos2 = i2 * 10 + 2;
            int pc = ByteArray.readU16bit(this.info, pos2);
            int len = ByteArray.readU16bit(this.info, pos2 + 2);
            if (pc > where || exclusive2 && pc == where && pc != 0) {
                ByteArray.write16bit(pc + gapLength, this.info, pos2);
                continue;
            }
            if (pc + len <= where && (!exclusive2 || pc + len != where)) continue;
            ByteArray.write16bit(len + gapLength, this.info, pos2 + 2);
        }
    }

    public int nameIndex(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 6);
    }

    public String variableName(int i2) {
        return this.getConstPool().getUtf8Info(this.nameIndex(i2));
    }

    public int descriptorIndex(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 8);
    }

    public int signatureIndex(int i2) {
        return this.descriptorIndex(i2);
    }

    public String descriptor(int i2) {
        return this.getConstPool().getUtf8Info(this.descriptorIndex(i2));
    }

    public String signature(int i2) {
        return this.descriptor(i2);
    }

    public int index(int i2) {
        return ByteArray.readU16bit(this.info, i2 * 10 + 10);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        byte[] src = this.get();
        byte[] dest = new byte[src.length];
        ConstPool cp = this.getConstPool();
        LocalVariableAttribute attr2 = this.makeThisAttr(newCp, dest);
        int n = ByteArray.readU16bit(src, 0);
        ByteArray.write16bit(n, dest, 0);
        int j = 2;
        for (int i2 = 0; i2 < n; ++i2) {
            int start2 = ByteArray.readU16bit(src, j);
            int len = ByteArray.readU16bit(src, j + 2);
            int name2 = ByteArray.readU16bit(src, j + 4);
            int type2 = ByteArray.readU16bit(src, j + 6);
            int index2 = ByteArray.readU16bit(src, j + 8);
            ByteArray.write16bit(start2, dest, j);
            ByteArray.write16bit(len, dest, j + 2);
            if (name2 != 0) {
                name2 = cp.copy(name2, newCp, null);
            }
            ByteArray.write16bit(name2, dest, j + 4);
            if (type2 != 0) {
                String sig = cp.getUtf8Info(type2);
                sig = Descriptor.rename(sig, classnames);
                type2 = newCp.addUtf8Info(sig);
            }
            ByteArray.write16bit(type2, dest, j + 6);
            ByteArray.write16bit(index2, dest, j + 8);
            j += 10;
        }
        return attr2;
    }

    LocalVariableAttribute makeThisAttr(ConstPool cp, byte[] dest) {
        return new LocalVariableAttribute(cp, tag, dest);
    }
}

