/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.CtClass;
import javassist.bytecode.ClassInfo;
import javassist.bytecode.ConstInfo;
import javassist.bytecode.ConstInfoPadding;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DoubleInfo;
import javassist.bytecode.FieldrefInfo;
import javassist.bytecode.FloatInfo;
import javassist.bytecode.IntegerInfo;
import javassist.bytecode.InterfaceMethodrefInfo;
import javassist.bytecode.LongInfo;
import javassist.bytecode.LongVector;
import javassist.bytecode.MemberrefInfo;
import javassist.bytecode.MethodrefInfo;
import javassist.bytecode.NameAndTypeInfo;
import javassist.bytecode.StringInfo;
import javassist.bytecode.Utf8Info;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    HashMap classes;
    HashMap strings;
    ConstInfo[] constInfoCache;
    int[] constInfoIndexCache;
    int thisClassInfo;
    private static final int CACHE_SIZE = 32;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final CtClass THIS = null;

    private static int hashFunc(int a, int b) {
        int h = -2128831035;
        int prime = 16777619;
        h = (h ^ a & 0xFF) * 16777619;
        h = (h ^ b & 0xFF) * 16777619;
        h = h >> 5 ^ h & 0x1F;
        return h & 0x1F;
    }

    public ConstPool(String thisclass) {
        this.items = new LongVector();
        this.numOfItems = 0;
        this.addItem(null);
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.constInfoCache = new ConstInfo[32];
        this.constInfoIndexCache = new int[32];
        this.thisClassInfo = this.addClassInfo(thisclass);
    }

    public ConstPool(DataInputStream in) throws IOException {
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.constInfoCache = new ConstInfo[32];
        this.constInfoIndexCache = new int[32];
        this.thisClassInfo = 0;
        this.read(in);
    }

    void prune() {
        this.classes = new HashMap();
        this.strings = new HashMap();
        this.constInfoCache = new ConstInfo[32];
        this.constInfoIndexCache = new int[32];
    }

    public int getSize() {
        return this.numOfItems;
    }

    public String getClassName() {
        return this.getClassInfo(this.thisClassInfo);
    }

    public int getThisClassInfo() {
        return this.thisClassInfo;
    }

    void setThisClassInfo(int i2) {
        this.thisClassInfo = i2;
    }

    ConstInfo getItem(int n) {
        return this.items.elementAt(n);
    }

    public int getTag(int index2) {
        return this.getItem(index2).getTag();
    }

    public String getClassInfo(int index2) {
        ClassInfo c = (ClassInfo)this.getItem(index2);
        if (c == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(c.name));
    }

    public String getClassInfoByDescriptor(int index2) {
        ClassInfo c = (ClassInfo)this.getItem(index2);
        if (c == null) {
            return null;
        }
        String className = this.getUtf8Info(c.name);
        if (className.charAt(0) == '[') {
            return className;
        }
        return Descriptor.of(className);
    }

    public int getNameAndTypeName(int index2) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index2);
        return ntinfo.memberName;
    }

    public int getNameAndTypeDescriptor(int index2) {
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(index2);
        return ntinfo.typeDescriptor;
    }

    public int getMemberClass(int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public int getMemberNameAndType(int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public int getFieldrefClass(int index2) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index2);
        return finfo.classIndex;
    }

    public String getFieldrefClassName(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        return this.getClassInfo(f.classIndex);
    }

    public int getFieldrefNameAndType(int index2) {
        FieldrefInfo finfo = (FieldrefInfo)this.getItem(index2);
        return finfo.nameAndTypeIndex;
    }

    public String getFieldrefName(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getFieldrefType(int index2) {
        FieldrefInfo f = (FieldrefInfo)this.getItem(index2);
        if (f == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(f.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getMethodrefClass(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public String getMethodrefClassName(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        return this.getClassInfo(minfo.classIndex);
    }

    public int getMethodrefNameAndType(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public String getMethodrefName(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getMethodrefType(int index2) {
        MethodrefInfo minfo = (MethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public int getInterfaceMethodrefClass(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return minfo.classIndex;
    }

    public String getInterfaceMethodrefClassName(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return this.getClassInfo(minfo.classIndex);
    }

    public int getInterfaceMethodrefNameAndType(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        return minfo.nameAndTypeIndex;
    }

    public String getInterfaceMethodrefName(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.memberName);
    }

    public String getInterfaceMethodrefType(int index2) {
        InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)this.getItem(index2);
        if (minfo == null) {
            return null;
        }
        NameAndTypeInfo n = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (n == null) {
            return null;
        }
        return this.getUtf8Info(n.typeDescriptor);
    }

    public Object getLdcValue(int index2) {
        ConstInfo constInfo = this.getItem(index2);
        Object value2 = null;
        value2 = constInfo instanceof StringInfo ? this.getStringInfo(index2) : (constInfo instanceof FloatInfo ? (Number)new Float(this.getFloatInfo(index2)) : (Number)(constInfo instanceof IntegerInfo ? (Number)new Integer(this.getIntegerInfo(index2)) : (Number)(constInfo instanceof LongInfo ? (Number)new Long(this.getLongInfo(index2)) : (Number)(constInfo instanceof DoubleInfo ? new Double(this.getDoubleInfo(index2)) : null))));
        return value2;
    }

    public int getIntegerInfo(int index2) {
        IntegerInfo i2 = (IntegerInfo)this.getItem(index2);
        return i2.value;
    }

    public float getFloatInfo(int index2) {
        FloatInfo i2 = (FloatInfo)this.getItem(index2);
        return i2.value;
    }

    public long getLongInfo(int index2) {
        LongInfo i2 = (LongInfo)this.getItem(index2);
        return i2.value;
    }

    public double getDoubleInfo(int index2) {
        DoubleInfo i2 = (DoubleInfo)this.getItem(index2);
        return i2.value;
    }

    public String getStringInfo(int index2) {
        StringInfo si = (StringInfo)this.getItem(index2);
        return this.getUtf8Info(si.string);
    }

    public String getUtf8Info(int index2) {
        Utf8Info utf = (Utf8Info)this.getItem(index2);
        return utf.string;
    }

    public int isConstructor(String classname, int index2) {
        return this.isMember(classname, "<init>", index2);
    }

    public int isMember(String classname, String membername, int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        if (this.getClassInfo(minfo.classIndex).equals(classname)) {
            NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
            if (this.getUtf8Info(ntinfo.memberName).equals(membername)) {
                return ntinfo.typeDescriptor;
            }
        }
        return 0;
    }

    public String eqMember(String membername, String desc, int index2) {
        MemberrefInfo minfo = (MemberrefInfo)this.getItem(index2);
        NameAndTypeInfo ntinfo = (NameAndTypeInfo)this.getItem(minfo.nameAndTypeIndex);
        if (this.getUtf8Info(ntinfo.memberName).equals(membername) && this.getUtf8Info(ntinfo.typeDescriptor).equals(desc)) {
            return this.getClassInfo(minfo.classIndex);
        }
        return null;
    }

    private int addItem(ConstInfo info) {
        this.items.addElement(info);
        return this.numOfItems++;
    }

    public int copy(int n, ConstPool dest, Map classnames) {
        if (n == 0) {
            return 0;
        }
        ConstInfo info = this.getItem(n);
        return info.copy(this, dest, classnames);
    }

    int addConstInfoPadding() {
        return this.addItem(new ConstInfoPadding());
    }

    public int addClassInfo(CtClass c) {
        if (c == THIS) {
            return this.thisClassInfo;
        }
        if (!c.isArray()) {
            return this.addClassInfo(c.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(c));
    }

    public int addClassInfo(String qname) {
        ClassInfo info = (ClassInfo)this.classes.get(qname);
        if (info != null) {
            return info.index;
        }
        int utf8 = this.addUtf8Info(Descriptor.toJvmName(qname));
        info = new ClassInfo(utf8, this.numOfItems);
        this.classes.put(qname, info);
        return this.addItem(info);
    }

    public int addNameAndTypeInfo(String name2, String type2) {
        return this.addNameAndTypeInfo(this.addUtf8Info(name2), this.addUtf8Info(type2));
    }

    public int addNameAndTypeInfo(int name2, int type2) {
        int i2;
        int h = ConstPool.hashFunc(name2, type2);
        ConstInfo ci = this.constInfoCache[h];
        if (ci != null && ci instanceof NameAndTypeInfo && ci.hashCheck(name2, type2)) {
            return this.constInfoIndexCache[h];
        }
        NameAndTypeInfo item = new NameAndTypeInfo(name2, type2);
        this.constInfoCache[h] = item;
        this.constInfoIndexCache[h] = i2 = this.addItem(item);
        return i2;
    }

    public int addFieldrefInfo(int classInfo, String name2, String type2) {
        int nt = this.addNameAndTypeInfo(name2, type2);
        return this.addFieldrefInfo(classInfo, nt);
    }

    public int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
        int i2;
        int h = ConstPool.hashFunc(classInfo, nameAndTypeInfo);
        ConstInfo ci = this.constInfoCache[h];
        if (ci != null && ci instanceof FieldrefInfo && ci.hashCheck(classInfo, nameAndTypeInfo)) {
            return this.constInfoIndexCache[h];
        }
        FieldrefInfo item = new FieldrefInfo(classInfo, nameAndTypeInfo);
        this.constInfoCache[h] = item;
        this.constInfoIndexCache[h] = i2 = this.addItem(item);
        return i2;
    }

    public int addMethodrefInfo(int classInfo, String name2, String type2) {
        int nt = this.addNameAndTypeInfo(name2, type2);
        return this.addMethodrefInfo(classInfo, nt);
    }

    public int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        int i2;
        int h = ConstPool.hashFunc(classInfo, nameAndTypeInfo);
        ConstInfo ci = this.constInfoCache[h];
        if (ci != null && ci instanceof MethodrefInfo && ci.hashCheck(classInfo, nameAndTypeInfo)) {
            return this.constInfoIndexCache[h];
        }
        MethodrefInfo item = new MethodrefInfo(classInfo, nameAndTypeInfo);
        this.constInfoCache[h] = item;
        this.constInfoIndexCache[h] = i2 = this.addItem(item);
        return i2;
    }

    public int addInterfaceMethodrefInfo(int classInfo, String name2, String type2) {
        int nt = this.addNameAndTypeInfo(name2, type2);
        return this.addInterfaceMethodrefInfo(classInfo, nt);
    }

    public int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        int i2;
        int h = ConstPool.hashFunc(classInfo, nameAndTypeInfo);
        ConstInfo ci = this.constInfoCache[h];
        if (ci != null && ci instanceof InterfaceMethodrefInfo && ci.hashCheck(classInfo, nameAndTypeInfo)) {
            return this.constInfoIndexCache[h];
        }
        InterfaceMethodrefInfo item = new InterfaceMethodrefInfo(classInfo, nameAndTypeInfo);
        this.constInfoCache[h] = item;
        this.constInfoIndexCache[h] = i2 = this.addItem(item);
        return i2;
    }

    public int addStringInfo(String str) {
        return this.addItem(new StringInfo(this.addUtf8Info(str)));
    }

    public int addIntegerInfo(int i2) {
        return this.addItem(new IntegerInfo(i2));
    }

    public int addFloatInfo(float f) {
        return this.addItem(new FloatInfo(f));
    }

    public int addLongInfo(long l) {
        int i2 = this.addItem(new LongInfo(l));
        this.addItem(new ConstInfoPadding());
        return i2;
    }

    public int addDoubleInfo(double d) {
        int i2 = this.addItem(new DoubleInfo(d));
        this.addItem(new ConstInfoPadding());
        return i2;
    }

    public int addUtf8Info(String utf8) {
        Utf8Info info = (Utf8Info)this.strings.get(utf8);
        if (info != null) {
            return info.index;
        }
        info = new Utf8Info(utf8, this.numOfItems);
        this.strings.put(utf8, info);
        return this.addItem(info);
    }

    public Set getClassNames() {
        HashSet<String> result2 = new HashSet<String>();
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i2 = 1; i2 < size2; ++i2) {
            String className = v.elementAt(i2).getClassName(this);
            if (className == null) continue;
            result2.add(className);
        }
        return result2;
    }

    public void renameClass(String oldName, String newName) {
        LongVector v = this.items;
        int size2 = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        for (int i2 = 1; i2 < size2; ++i2) {
            ConstInfo ci = v.elementAt(i2);
            ci.renameClass(this, oldName, newName);
            ci.makeHashtable(this);
        }
    }

    public void renameClass(Map classnames) {
        LongVector v = this.items;
        int size2 = this.numOfItems;
        this.classes = new HashMap(this.classes.size() * 2);
        for (int i2 = 1; i2 < size2; ++i2) {
            ConstInfo ci = v.elementAt(i2);
            ci.renameClass(this, classnames);
            ci.makeHashtable(this);
        }
    }

    private void read(DataInputStream in) throws IOException {
        ConstInfo info;
        int n = in.readUnsignedShort();
        this.items = new LongVector(n);
        this.numOfItems = 0;
        this.addItem(null);
        while (--n > 0) {
            int tag2 = this.readOne(in);
            if (tag2 != 5 && tag2 != 6) continue;
            this.addItem(new ConstInfoPadding());
            --n;
        }
        int i2 = 1;
        while ((info = this.items.elementAt(i2++)) != null) {
            info.makeHashtable(this);
        }
    }

    private int readOne(DataInputStream in) throws IOException {
        ConstInfo info;
        int tag2 = in.readUnsignedByte();
        switch (tag2) {
            case 1: {
                info = new Utf8Info(in, this.numOfItems);
                this.strings.put(((Utf8Info)info).string, info);
                break;
            }
            case 3: {
                info = new IntegerInfo(in);
                break;
            }
            case 4: {
                info = new FloatInfo(in);
                break;
            }
            case 5: {
                info = new LongInfo(in);
                break;
            }
            case 6: {
                info = new DoubleInfo(in);
                break;
            }
            case 7: {
                info = new ClassInfo(in, this.numOfItems);
                break;
            }
            case 8: {
                info = new StringInfo(in);
                break;
            }
            case 9: {
                info = new FieldrefInfo(in);
                break;
            }
            case 10: {
                info = new MethodrefInfo(in);
                break;
            }
            case 11: {
                info = new InterfaceMethodrefInfo(in);
                break;
            }
            case 12: {
                info = new NameAndTypeInfo(in);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + tag2);
            }
        }
        this.addItem(info);
        return tag2;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.numOfItems);
        LongVector v = this.items;
        int size2 = this.numOfItems;
        for (int i2 = 1; i2 < size2; ++i2) {
            v.elementAt(i2).write(out);
        }
    }

    public void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public void print(PrintWriter out) {
        int size2 = this.numOfItems;
        for (int i2 = 1; i2 < size2; ++i2) {
            out.print(i2);
            out.print(" ");
            this.items.elementAt(i2).print(out);
        }
    }
}

