/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Message;
import http_parser.lolevel.ParserSettings;
import http_parser.lolevel.TestLoaderNG;
import java.nio.ByteBuffer;
import java.util.List;
import primitive.collection.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    static final ParserSettings SETTINGS_NULL = new ParserSettings();

    static String str(ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        byteBuffer.position(n3);
        return new String(byArray);
    }

    static String str(ByteBuffer byteBuffer) {
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        int n2 = byteBuffer.position();
        byteBuffer.get(byArray);
        byteBuffer.position(n2);
        return new String(byArray);
    }

    static ByteBuffer buffer(String string2) {
        return ByteBuffer.wrap(string2.getBytes());
    }

    static ByteBuffer empty() {
        return ByteBuffer.wrap(new byte[0]);
    }

    static void check(boolean bl) {
        if (!bl) {
            throw new RuntimeException("!");
        }
    }

    static void test_message(Message message2) {
        int n = message2.raw.length;
        for (int j = 0; j != n; ++j) {
            message2.reset();
            ByteBuffer byteBuffer = ByteBuffer.wrap(message2.raw, 0, j);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(message2.raw, j, message2.raw.length - j);
            HTTPParser hTTPParser = new HTTPParser(message2.type);
            TestLoaderNG.TestSettings testSettings = message2.settings();
            int n2 = 0;
            if (j != 0) {
                n2 = hTTPParser.execute(testSettings, byteBuffer);
                if (message2.upgrade && hTTPParser.upgrade) {
                    Util.check(1 == message2.num_called);
                    continue;
                }
                Util.check(n2 == j);
            }
            n2 = hTTPParser.execute(testSettings, byteBuffer2);
            if (message2.upgrade && hTTPParser.upgrade) {
                Util.check(1 == message2.num_called);
                continue;
            }
            Util.check(n2 == message2.raw.length - j);
            ByteBuffer byteBuffer3 = Util.empty();
            n2 = hTTPParser.execute(testSettings, byteBuffer3);
            if (message2.upgrade && hTTPParser.upgrade) {
                Util.check(1 == message2.num_called);
                continue;
            }
            Util.check(byteBuffer3.position() == byteBuffer3.limit());
            Util.check(0 == n2);
            Util.check(1 == message2.num_called);
        }
    }

    static void test_multiple3(Message message2, Message message3, Message message4) {
        int n = 1;
        if (!message2.upgrade) {
            ++n;
            if (!message3.upgrade) {
                ++n;
            }
        }
        boolean bl = n < 3 || message4.upgrade;
        ByteList byteList = new ByteList();
        byteList.addAll(message2.raw);
        byteList.addAll(message3.raw);
        byteList.addAll(message4.raw);
        byte[] byArray = byteList.toArray();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Settings settings = Util.settings();
        HTTPParser hTTPParser = new HTTPParser(message2.type);
        int n2 = hTTPParser.execute(settings, byteBuffer);
        if (bl && hTTPParser.upgrade) {
            Util.check(settings.numCalled == n);
            return;
        }
        Util.check(n2 == byArray.length);
        byteBuffer = Util.empty();
        n2 = hTTPParser.execute(settings, byteBuffer);
        if (bl && hTTPParser.upgrade) {
            Util.check(settings.numCalled == n);
            return;
        }
        Util.check(0 == n2);
        Util.check(settings.numCalled == n);
    }

    static void p(Object object) {
        System.out.println(object);
    }

    static Settings settings() {
        return new Settings();
    }

    static Message find(List<Message> list2, String string2) {
        for (Message message2 : list2) {
            if (!string2.equals(message2.name)) continue;
            return message2;
        }
        return null;
    }

    static class Settings
    extends ParserSettings {
        public int numCalled;
        public int bodyCount;

        Settings() {
            this.on_message_complete = new HTTPCallback(){

                public int cb(HTTPParser hTTPParser) {
                    ++Settings.this.numCalled;
                    return 0;
                }
            };
            this.on_body = new HTTPDataCallback(){

                public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                    Settings.this.bodyCount += n2;
                    return 0;
                }
            };
        }

        int numCalled() {
            return this.numCalled;
        }
    }
}

