/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.linearref.LengthIndexedLine;

public class LinearRefExample {
    static GeometryFactory fact = new GeometryFactory();
    static WKTReader rdr = new WKTReader(fact);

    public static void main(String[] args2) throws Exception {
        LinearRefExample example = new LinearRefExample();
        example.run();
    }

    public void run() throws Exception {
        this.runExtractedLine("LINESTRING (0 0, 10 10, 20 20)", 1.0, 10.0);
        this.runExtractedLine("MULTILINESTRING ((0 0, 10 10), (20 20, 25 25, 30 40))", 1.0, 20.0);
    }

    public void runExtractedLine(String wkt, double start2, double end2) throws ParseException {
        System.out.println("=========================");
        Geometry g1 = rdr.read(wkt);
        System.out.println("Input Geometry: " + g1);
        System.out.println("Indices to extract: " + start2 + " " + end2);
        LengthIndexedLine indexedLine = new LengthIndexedLine(g1);
        Geometry subLine = indexedLine.extractLine(start2, end2);
        System.out.println("Extracted Line: " + subLine);
        double[] index2 = indexedLine.indicesOf(subLine);
        System.out.println("Indices of extracted line: " + index2[0] + " " + index2[1]);
        Coordinate midpt = indexedLine.extractPoint((index2[0] + index2[1]) / 2.0);
        System.out.println("Midpoint of extracted line: " + midpt);
    }
}

