/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.io.gml2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import com.vividsolutions.jtsexample.io.gml2.FixingGeometryFactory;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class KMLHandler
extends DefaultHandler {
    private List geoms = new ArrayList();
    private GMLHandler currGeomHandler;
    private String lastEltName = null;
    private GeometryFactory fact = new FixingGeometryFactory();

    public List getGeometries() {
        return this.geoms;
    }

    public void startElement(String uri, String name2, String qName, Attributes atts) throws SAXException {
        if (name2.equalsIgnoreCase("Polygon")) {
            this.currGeomHandler = new GMLHandler(this.fact, null);
        }
        if (this.currGeomHandler != null) {
            this.currGeomHandler.startElement(uri, name2, qName, atts);
        }
        if (this.currGeomHandler == null) {
            this.lastEltName = name2;
        }
    }

    public void characters(char[] ch, int start2, int length2) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.characters(ch, start2, length2);
        } else {
            String content = new String(ch, start2, length2).trim();
            if (content.length() > 0) {
                System.out.println(this.lastEltName + "= " + content);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start2, int length2) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.ignorableWhitespace(ch, start2, length2);
        }
    }

    public void endElement(String uri, String name2, String qName) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.endElement(uri, name2, qName);
            if (this.currGeomHandler.isGeometryComplete()) {
                Geometry g = this.currGeomHandler.getGeometry();
                System.out.println(g);
                this.geoms.add(g);
                this.currGeomHandler = null;
            }
        }
    }
}

