/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.random;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.math.MathUtil;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;
import java.util.ArrayList;

public class RandomPointsInGridBuilder
extends GeometricShapeBuilder {
    private boolean isConstrainedToCircle = false;
    private double gutterFraction = 0.0;

    public RandomPointsInGridBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsInGridBuilder(GeometryFactory geomFact) {
        super(geomFact);
    }

    public void setConstrainedToCircle(boolean isConstrainedToCircle) {
        this.isConstrainedToCircle = isConstrainedToCircle;
    }

    public void setGutterFraction(double gutterFraction) {
        this.gutterFraction = gutterFraction;
    }

    public Geometry getGeometry() {
        int nCells = (int)Math.sqrt(this.numPts) + 1;
        double gridDX = this.getExtent().getWidth() / (double)nCells;
        double gridDY = this.getExtent().getHeight() / (double)nCells;
        double gutterFrac = MathUtil.clamp(this.gutterFraction, 0.0, 1.0);
        double gutterOffsetX = gridDX * gutterFrac / 2.0;
        double gutterOffsetY = gridDY * gutterFrac / 2.0;
        double cellFrac = 1.0 - gutterFrac;
        double cellDX = cellFrac * gridDX;
        double cellDY = cellFrac * gridDY;
        ArrayList<Coordinate> pts = new ArrayList<Coordinate>();
        for (int i2 = 0; i2 < nCells; ++i2) {
            for (int j = 0; j < nCells; ++j) {
                double orgX = this.getExtent().getMinX() + (double)i2 * gridDX + gutterOffsetX;
                double orgY = this.getExtent().getMinY() + (double)j * gridDY + gutterOffsetY;
                pts.add(this.randomPointInCell(orgX, orgY, cellDX, cellDY));
            }
        }
        return this.geomFactory.createMultiPoint(CoordinateArrays.toCoordinateArray(pts));
    }

    private Coordinate randomPointInCell(double orgX, double orgY, double xLen, double yLen) {
        if (this.isConstrainedToCircle) {
            RandomPointsInGridBuilder.randomPointInCircle(orgX, orgY, xLen, yLen);
        }
        return this.randomPointInGridCell(orgX, orgY, xLen, yLen);
    }

    private Coordinate randomPointInGridCell(double orgX, double orgY, double xLen, double yLen) {
        double x = orgX + xLen * Math.random();
        double y = orgY + yLen * Math.random();
        return this.createCoord(x, y);
    }

    private static Coordinate randomPointInCircle(double orgX, double orgY, double width, double height) {
        double centreX = orgX + width / 2.0;
        double centreY = orgX + height / 2.0;
        double rndAng = Math.PI * 2 * Math.random();
        double rndRadius = Math.random();
        double rndRadius2 = Math.sqrt(rndRadius);
        double rndX = width / 2.0 * rndRadius2 * Math.cos(rndAng);
        double rndY = height / 2.0 * rndRadius2 * Math.sin(rndAng);
        double x0 = centreX + rndX;
        double y0 = centreY + rndY;
        return new Coordinate(x0, y0);
    }
}

