/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.shape.fractal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.shape.GeometricShapeBuilder;
import java.util.ArrayList;
import java.util.List;

public class SierpinskiCarpetBuilder
extends GeometricShapeBuilder {
    private CoordinateList coordList = new CoordinateList();

    public SierpinskiCarpetBuilder(GeometryFactory geomFactory) {
        super(geomFactory);
    }

    public static int recursionLevelForSize(int numPts) {
        double pow4 = numPts / 3;
        double exp2 = Math.log(pow4) / Math.log(4.0);
        return (int)exp2;
    }

    public Geometry getGeometry() {
        int level2 = SierpinskiCarpetBuilder.recursionLevelForSize(this.numPts);
        LineSegment baseLine = this.getSquareBaseLine();
        Coordinate origin = baseLine.getCoordinate(0);
        LinearRing[] holes = this.getHoles(level2, origin.x, origin.y, this.getDiameter());
        LinearRing shell = (LinearRing)((Polygon)this.geomFactory.toGeometry(this.getSquareExtent())).getExteriorRing();
        return this.geomFactory.createPolygon(shell, holes);
    }

    private LinearRing[] getHoles(int n, double originX, double originY, double width) {
        ArrayList holeList = new ArrayList();
        this.addHoles(n, originX, originY, width, holeList);
        return GeometryFactory.toLinearRingArray(holeList);
    }

    private void addHoles(int n, double originX, double originY, double width, List holeList) {
        if (n < 0) {
            return;
        }
        int n2 = n - 1;
        double widthThird = width / 3.0;
        double widthTwoThirds = width * 2.0 / 3.0;
        double widthNinth = width / 9.0;
        this.addHoles(n2, originX, originY, widthThird, holeList);
        this.addHoles(n2, originX + widthThird, originY, widthThird, holeList);
        this.addHoles(n2, originX + 2.0 * widthThird, originY, widthThird, holeList);
        this.addHoles(n2, originX, originY + widthThird, widthThird, holeList);
        this.addHoles(n2, originX + 2.0 * widthThird, originY + widthThird, widthThird, holeList);
        this.addHoles(n2, originX, originY + 2.0 * widthThird, widthThird, holeList);
        this.addHoles(n2, originX + widthThird, originY + 2.0 * widthThird, widthThird, holeList);
        this.addHoles(n2, originX + 2.0 * widthThird, originY + 2.0 * widthThird, widthThird, holeList);
        holeList.add(this.createSquareHole(originX + widthThird, originY + widthThird, widthThird));
    }

    private LinearRing createSquareHole(double x, double y, double width) {
        Coordinate[] pts = new Coordinate[]{new Coordinate(x, y), new Coordinate(x + width, y), new Coordinate(x + width, y + width), new Coordinate(x, y + width), new Coordinate(x, y)};
        return this.geomFactory.createLinearRing(pts);
    }
}

