/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class RepeatedPointTester {
    private Coordinate repeatedCoord;

    public Coordinate getCoordinate() {
        return this.repeatedCoord;
    }

    public boolean hasRepeatedPoint(Geometry g) {
        if (g.isEmpty()) {
            return false;
        }
        if (g instanceof Point) {
            return false;
        }
        if (g instanceof MultiPoint) {
            return false;
        }
        if (g instanceof LineString) {
            return this.hasRepeatedPoint(((LineString)g).getCoordinates());
        }
        if (g instanceof Polygon) {
            return this.hasRepeatedPoint((Polygon)g);
        }
        if (g instanceof GeometryCollection) {
            return this.hasRepeatedPoint((GeometryCollection)g);
        }
        throw new UnsupportedOperationException(g.getClass().getName());
    }

    public boolean hasRepeatedPoint(Coordinate[] coord) {
        for (int i2 = 1; i2 < coord.length; ++i2) {
            if (!coord[i2 - 1].equals(coord[i2])) continue;
            this.repeatedCoord = coord[i2];
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(Polygon p2) {
        if (this.hasRepeatedPoint(p2.getExteriorRing().getCoordinates())) {
            return true;
        }
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            if (!this.hasRepeatedPoint(p2.getInteriorRingN(i2).getCoordinates())) continue;
            return true;
        }
        return false;
    }

    private boolean hasRepeatedPoint(GeometryCollection gc2) {
        for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
            Geometry g = gc2.getGeometryN(i2);
            if (!this.hasRepeatedPoint(g)) continue;
            return true;
        }
        return false;
    }
}

