/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.linemerge;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.linemerge.EdgeString;
import com.vividsolutions.jts.operation.linemerge.LineMergeDirectedEdge;
import com.vividsolutions.jts.operation.linemerge.LineMergeGraph;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class LineMerger {
    private LineMergeGraph graph = new LineMergeGraph();
    private Collection mergedLineStrings = null;
    private GeometryFactory factory = null;
    private Collection edgeStrings = null;

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    LineMerger.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        this.mergedLineStrings = null;
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        GraphComponent.setMarked(this.graph.nodeIterator(), false);
        GraphComponent.setMarked(this.graph.edgeIterator(), false);
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        for (EdgeString edgeString : this.edgeStrings) {
            this.mergedLineStrings.add(edgeString.toLineString());
        }
    }

    private void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private void buildEdgeStringsForUnprocessedNodes() {
        for (Node node : this.graph.getNodes()) {
            if (node.isMarked()) continue;
            Assert.isTrue(node.getDegree() == 2);
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsForNonDegree2Nodes() {
        for (Node node : this.graph.getNodes()) {
            if (node.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsStartingAt(Node node) {
        Iterator i2 = node.getOutEdges().iterator();
        while (i2.hasNext()) {
            LineMergeDirectedEdge directedEdge = (LineMergeDirectedEdge)i2.next();
            if (directedEdge.getEdge().isMarked()) continue;
            this.edgeStrings.add(this.buildEdgeStringStartingWith(directedEdge));
        }
    }

    private EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge start2) {
        EdgeString edgeString = new EdgeString(this.factory);
        LineMergeDirectedEdge current2 = start2;
        do {
            edgeString.add(current2);
            current2.getEdge().setMarked(true);
        } while ((current2 = current2.getNext()) != null && current2 != start2);
        return edgeString;
    }

    public Collection getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }
}

