/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.noding.NodableSegmentString;
import com.vividsolutions.jts.noding.Octant;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentNodeList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodedSegmentString
implements NodableSegmentString {
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object data;

    public static List getNodedSubstrings(Collection segStrings) {
        ArrayList resultEdgelist = new ArrayList();
        NodedSegmentString.getNodedSubstrings(segStrings, resultEdgelist);
        return resultEdgelist;
    }

    public static void getNodedSubstrings(Collection segStrings, Collection resultEdgelist) {
        for (NodedSegmentString ss : segStrings) {
            ss.getNodeList().addSplitEdges(resultEdgelist);
        }
    }

    public NodedSegmentString(Coordinate[] pts, Object data2) {
        this.pts = pts;
        this.data = data2;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data2) {
        this.data = data2;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    public int size() {
        return this.pts.length;
    }

    public Coordinate getCoordinate(int i2) {
        return this.pts[i2];
    }

    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public int getSegmentOctant(int index2) {
        if (index2 == this.pts.length - 1) {
            return -1;
        }
        return this.safeOctant(this.getCoordinate(index2), this.getCoordinate(index2 + 1));
    }

    private int safeOctant(Coordinate p0, Coordinate p1) {
        if (p0.equals2D(p1)) {
            return 0;
        }
        return Octant.octant(p0, p1);
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        for (int i2 = 0; i2 < li.getIntersectionNum(); ++i2) {
            this.addIntersection(li, segmentIndex, geomIndex, i2);
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate intPt = new Coordinate(li.getIntersection(intIndex));
        this.addIntersection(intPt, segmentIndex);
    }

    public void addIntersection(Coordinate intPt, int segmentIndex) {
        this.addIntersectionNode(intPt, segmentIndex);
    }

    public SegmentNode addIntersectionNode(Coordinate intPt, int segmentIndex) {
        Coordinate nextPt;
        int normalizedSegmentIndex = segmentIndex;
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
        }
        SegmentNode ei = this.nodeList.add(intPt, normalizedSegmentIndex);
        return ei;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

