/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class WKTWriter {
    private static int INDENT = 2;
    private int outputDimension = 2;
    private DecimalFormat formatter;
    private boolean isFormatted = false;
    private boolean useFormatting = false;
    private int level = 0;
    private int coordsPerLine = -1;
    private String indentTabStr = "  ";

    public static String toPoint(Coordinate p0) {
        return "POINT ( " + p0.x + " " + p0.y + " )";
    }

    public static String toLineString(CoordinateSequence seq) {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ");
        if (seq.size() == 0) {
            buf.append(" EMPTY");
        } else {
            buf.append("(");
            for (int i2 = 0; i2 < seq.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(", ");
                }
                buf.append(seq.getX(i2) + " " + seq.getY(i2));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate p0, Coordinate p1) {
        return "LINESTRING ( " + p0.x + " " + p0.y + ", " + p1.x + " " + p1.y + " )";
    }

    private static DecimalFormat createFormatter(PrecisionModel precisionModel) {
        int decimalPlaces = precisionModel.getMaximumSignificantDigits();
        DecimalFormatSymbols symbols2 = new DecimalFormatSymbols();
        symbols2.setDecimalSeparator('.');
        String fmtString = "0" + (decimalPlaces > 0 ? "." : "") + WKTWriter.stringOfChar('#', decimalPlaces);
        return new DecimalFormat(fmtString, symbols2);
    }

    public static String stringOfChar(char ch, int count2) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < count2; ++i2) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public WKTWriter() {
    }

    public WKTWriter(int outputDimension) {
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 or 3)");
        }
    }

    public void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    public void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    public void setTab(int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter.stringOfChar(' ', size2);
    }

    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, this.isFormatted, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, false, writer);
    }

    public String writeFormatted(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }

    private void writeFormatted(Geometry geometry, boolean useFormatting, Writer writer) throws IOException {
        this.useFormatting = useFormatting;
        this.formatter = WKTWriter.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private void appendGeometryTaggedText(Geometry geometry, int level2, Writer writer) throws IOException {
        this.indent(level2, writer);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), level2, writer, point.getPrecisionModel());
        } else if (geometry instanceof LinearRing) {
            this.appendLinearRingTaggedText((LinearRing)geometry, level2, writer);
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, level2, writer);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, level2, writer);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, level2, writer);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, level2, writer);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, level2, writer);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, level2, writer);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + geometry.getClass());
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, int level2, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, level2, writer, precisionModel);
    }

    private void appendLineStringTaggedText(LineString lineString, int level2, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, level2, false, writer);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int level2, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText(linearRing, level2, false, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, int level2, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, level2, false, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, int level2, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multipoint, level2, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int level2, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, level2, false, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int level2, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, level2, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int level2, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, level2, writer);
    }

    private void appendPointText(Coordinate coordinate, int level2, Writer writer, PrecisionModel precisionModel) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer);
            writer.write(")");
        }
    }

    private void appendCoordinate(CoordinateSequence seq, int i2, Writer writer) throws IOException {
        double z;
        writer.write(this.writeNumber(seq.getX(i2)) + " " + this.writeNumber(seq.getY(i2)));
        if (this.outputDimension >= 3 && seq.getDimension() >= 3 && !Double.isNaN(z = seq.getOrdinate(i2, 3))) {
            writer.write(" ");
            writer.write(this.writeNumber(z));
        }
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y));
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.z)) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.z));
        }
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    private void appendSequenceText(CoordinateSequence seq, int level2, boolean doIndent, Writer writer) throws IOException {
        if (seq.size() == 0) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level2, writer);
            }
            writer.write("(");
            for (int i2 = 0; i2 < seq.size(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i2 % this.coordsPerLine == 0) {
                        this.indent(level2 + 1, writer);
                    }
                }
                this.appendCoordinate(seq, i2, writer);
            }
            writer.write(")");
        }
    }

    private void appendLineStringText(LineString lineString, int level2, boolean doIndent, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level2, writer);
            }
            writer.write("(");
            for (int i2 = 0; i2 < lineString.getNumPoints(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i2 % this.coordsPerLine == 0) {
                        this.indent(level2 + 1, writer);
                    }
                }
                this.appendCoordinate(lineString.getCoordinateN(i2), writer);
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, int level2, boolean indentFirst, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(level2, writer);
            }
            writer.write("(");
            this.appendLineStringText(polygon.getExteriorRing(), level2, false, writer);
            for (int i2 = 0; i2 < polygon.getNumInteriorRing(); ++i2) {
                writer.write(", ");
                this.appendLineStringText(polygon.getInteriorRingN(i2), level2 + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, int level2, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i2 = 0; i2 < multiPoint.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    this.indentCoords(i2, level2 + 1, writer);
                }
                writer.write("(");
                this.appendCoordinate(((Point)multiPoint.getGeometryN(i2)).getCoordinate(), writer);
                writer.write(")");
            }
            writer.write(")");
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, int level2, boolean indentFirst, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level22 = level2;
            boolean doIndent = indentFirst;
            writer.write("(");
            for (int i2 = 0; i2 < multiLineString.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level22 = level2 + 1;
                    doIndent = true;
                }
                this.appendLineStringText((LineString)multiLineString.getGeometryN(i2), level22, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, int level2, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level22 = level2;
            boolean doIndent = false;
            writer.write("(");
            for (int i2 = 0; i2 < multiPolygon.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level22 = level2 + 1;
                    doIndent = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i2), level22, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int level2, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level22 = level2;
            writer.write("(");
            for (int i2 = 0; i2 < geometryCollection.getNumGeometries(); ++i2) {
                if (i2 > 0) {
                    writer.write(", ");
                    level22 = level2 + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i2), level22, writer);
            }
            writer.write(")");
        }
    }

    private void indentCoords(int coordIndex, int level2, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(level2, writer);
    }

    private void indent(int level2, Writer writer) throws IOException {
        if (!this.useFormatting || level2 <= 0) {
            return;
        }
        writer.write("\n");
        for (int i2 = 0; i2 < level2; ++i2) {
            writer.write(this.indentTabStr);
        }
    }
}

