/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.lang.ref.SoftReference;

public abstract class PackedCoordinateSequence
implements CoordinateSequence {
    protected int dimension;
    protected SoftReference coordRef;

    public int getDimension() {
        return this.dimension;
    }

    public Coordinate getCoordinate(int i2) {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords[i2];
        }
        return this.getCoordinateInternal(i2);
    }

    public Coordinate getCoordinateCopy(int i2) {
        return this.getCoordinateInternal(i2);
    }

    public void getCoordinate(int i2, Coordinate coord) {
        coord.x = this.getOrdinate(i2, 0);
        coord.y = this.getOrdinate(i2, 1);
        if (this.dimension > 2) {
            coord.z = this.getOrdinate(i2, 2);
        }
    }

    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords;
        }
        coords = new Coordinate[this.size()];
        for (int i2 = 0; i2 < coords.length; ++i2) {
            coords[i2] = this.getCoordinateInternal(i2);
        }
        this.coordRef = new SoftReference<Coordinate[]>(coords);
        return coords;
    }

    private Coordinate[] getCachedCoords() {
        if (this.coordRef != null) {
            Coordinate[] coords = (Coordinate[])this.coordRef.get();
            if (coords != null) {
                return coords;
            }
            this.coordRef = null;
            return null;
        }
        return null;
    }

    public double getX(int index2) {
        return this.getOrdinate(index2, 0);
    }

    public double getY(int index2) {
        return this.getOrdinate(index2, 1);
    }

    public abstract double getOrdinate(int var1, int var2);

    public void setX(int index2, double value2) {
        this.coordRef = null;
        this.setOrdinate(index2, 0, value2);
    }

    public void setY(int index2, double value2) {
        this.coordRef = null;
        this.setOrdinate(index2, 1, value2);
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    public abstract Object clone();

    public abstract void setOrdinate(int var1, int var2, double var3);

    public static class Float
    extends PackedCoordinateSequence {
        float[] coords;

        public Float(float[] coords, int dimensions2) {
            if (dimensions2 < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions2 != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions2;
            this.coords = coords;
        }

        public Float(double[] coordinates, int dimensions2) {
            this.coords = new float[coordinates.length];
            this.dimension = dimensions2;
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                this.coords[i2] = (float)coordinates[i2];
            }
        }

        public Float(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new float[coordinates.length * this.dimension];
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                this.coords[i2 * this.dimension] = (float)coordinates[i2].x;
                if (this.dimension >= 2) {
                    this.coords[i2 * this.dimension + 1] = (float)coordinates[i2].y;
                }
                if (this.dimension < 3) continue;
                this.coords[i2 * this.dimension + 2] = (float)coordinates[i2].z;
            }
        }

        public Float(int size2, int dimension) {
            this.dimension = dimension;
            this.coords = new float[size2 * this.dimension];
        }

        public Coordinate getCoordinateInternal(int i2) {
            double x = this.coords[i2 * this.dimension];
            double y = this.coords[i2 * this.dimension + 1];
            double z = this.dimension == 2 ? java.lang.Double.NaN : (double)this.coords[i2 * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        public Object clone() {
            float[] clone = new float[this.coords.length];
            System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
            return new Float(clone, this.dimension);
        }

        public double getOrdinate(int index2, int ordinate) {
            return this.coords[index2 * this.dimension + ordinate];
        }

        public void setOrdinate(int index2, int ordinate, double value2) {
            this.coordRef = null;
            this.coords[index2 * this.dimension + ordinate] = (float)value2;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i2 = 0; i2 < this.coords.length; i2 += this.dimension) {
                env.expandToInclude(this.coords[i2], this.coords[i2 + 1]);
            }
            return env;
        }
    }

    public static class Double
    extends PackedCoordinateSequence {
        double[] coords;

        public Double(double[] coords, int dimensions2) {
            if (dimensions2 < 2) {
                throw new IllegalArgumentException("Must have at least 2 dimensions");
            }
            if (coords.length % dimensions2 != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.dimension = dimensions2;
            this.coords = coords;
        }

        public Double(float[] coordinates, int dimensions2) {
            this.coords = new double[coordinates.length];
            this.dimension = dimensions2;
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                this.coords[i2] = coordinates[i2];
            }
        }

        public Double(Coordinate[] coordinates, int dimension) {
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.dimension = dimension;
            this.coords = new double[coordinates.length * this.dimension];
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                this.coords[i2 * this.dimension] = coordinates[i2].x;
                if (this.dimension >= 2) {
                    this.coords[i2 * this.dimension + 1] = coordinates[i2].y;
                }
                if (this.dimension < 3) continue;
                this.coords[i2 * this.dimension + 2] = coordinates[i2].z;
            }
        }

        public Double(Coordinate[] coordinates) {
            this(coordinates, 3);
        }

        public Double(int size2, int dimension) {
            this.dimension = dimension;
            this.coords = new double[size2 * this.dimension];
        }

        public Coordinate getCoordinateInternal(int i2) {
            double x = this.coords[i2 * this.dimension];
            double y = this.coords[i2 * this.dimension + 1];
            double z = this.dimension == 2 ? java.lang.Double.NaN : this.coords[i2 * this.dimension + 2];
            return new Coordinate(x, y, z);
        }

        public int size() {
            return this.coords.length / this.dimension;
        }

        public Object clone() {
            double[] clone = new double[this.coords.length];
            System.arraycopy(this.coords, 0, clone, 0, this.coords.length);
            return new Double(clone, this.dimension);
        }

        public double getOrdinate(int index2, int ordinate) {
            return this.coords[index2 * this.dimension + ordinate];
        }

        public void setOrdinate(int index2, int ordinate, double value2) {
            this.coordRef = null;
            this.coords[index2 * this.dimension + ordinate] = value2;
        }

        public Envelope expandEnvelope(Envelope env) {
            for (int i2 = 0; i2 < this.coords.length; i2 += this.dimension) {
                env.expandToInclude(this.coords[i2], this.coords[i2 + 1]);
            }
            return env;
        }
    }
}

