/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CoordinateList
extends ArrayList {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public CoordinateList() {
    }

    public CoordinateList(Coordinate[] coord) {
        this.ensureCapacity(coord.length);
        this.add(coord, true);
    }

    public CoordinateList(Coordinate[] coord, boolean allowRepeated) {
        this.ensureCapacity(coord.length);
        this.add(coord, allowRepeated);
    }

    public Coordinate getCoordinate(int i2) {
        return (Coordinate)this.get(i2);
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, int start2, int end2) {
        int inc = 1;
        if (start2 > end2) {
            inc = -1;
        }
        for (int i2 = start2; i2 != end2; i2 += inc) {
            this.add(coord[i2], allowRepeated);
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated, boolean direction) {
        if (direction) {
            for (int i2 = 0; i2 < coord.length; ++i2) {
                this.add(coord[i2], allowRepeated);
            }
        } else {
            for (int i3 = coord.length - 1; i3 >= 0; --i3) {
                this.add(coord[i3], allowRepeated);
            }
        }
        return true;
    }

    public boolean add(Coordinate[] coord, boolean allowRepeated) {
        this.add(coord, allowRepeated, true);
        return true;
    }

    public boolean add(Object obj, boolean allowRepeated) {
        this.add((Coordinate)obj, allowRepeated);
        return true;
    }

    public void add(Coordinate coord, boolean allowRepeated) {
        Coordinate last2;
        if (!allowRepeated && this.size() >= 1 && (last2 = (Coordinate)this.get(this.size() - 1)).equals2D(coord)) {
            return;
        }
        super.add(coord);
    }

    public void add(int i2, Coordinate coord, boolean allowRepeated) {
        int size2;
        if (!allowRepeated && (size2 = this.size()) > 0) {
            Coordinate next;
            Coordinate prev;
            if (i2 > 0 && (prev = (Coordinate)this.get(i2 - 1)).equals2D(coord)) {
                return;
            }
            if (i2 < size2 && (next = (Coordinate)this.get(i2)).equals2D(coord)) {
                return;
            }
        }
        super.add(i2, coord);
    }

    public boolean addAll(Collection coll, boolean allowRepeated) {
        boolean isChanged = false;
        Iterator i2 = coll.iterator();
        while (i2.hasNext()) {
            this.add((Coordinate)i2.next(), allowRepeated);
            isChanged = true;
        }
        return isChanged;
    }

    public void closeRing() {
        if (this.size() > 0) {
            this.add(new Coordinate((Coordinate)this.get(0)), false);
        }
    }

    public Coordinate[] toCoordinateArray() {
        return this.toArray(coordArrayType);
    }

    public Object clone() {
        CoordinateList clone = (CoordinateList)super.clone();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            clone.add(i2, ((Coordinate)this.get(i2)).clone());
        }
        return clone;
    }
}

