/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.math.MathUtil;
import java.util.Collection;
import java.util.Comparator;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static boolean isRing(Coordinate[] pts) {
        if (pts.length < 4) {
            return false;
        }
        return pts[0].equals2D(pts[pts.length - 1]);
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i2 = 0; i2 < testPts.length; ++i2) {
            Coordinate testPt = testPts[i2];
            if (CoordinateArrays.indexOf(testPt, pts) >= 0) continue;
            return testPt;
        }
        return null;
    }

    public static int compare(Coordinate[] pts1, Coordinate[] pts2) {
        int i2;
        for (i2 = 0; i2 < pts1.length && i2 < pts2.length; ++i2) {
            int compare = pts1[i2].compareTo(pts2[i2]);
            if (compare == 0) continue;
            return compare;
        }
        if (i2 < pts2.length) {
            return -1;
        }
        if (i2 < pts1.length) {
            return 1;
        }
        return 0;
    }

    public static int increasingDirection(Coordinate[] pts) {
        for (int i2 = 0; i2 < pts.length / 2; ++i2) {
            int j = pts.length - 1 - i2;
            int comp = pts[i2].compareTo(pts[j]);
            if (comp == 0) continue;
            return comp;
        }
        return 1;
    }

    private static boolean isEqualReversed(Coordinate[] pts1, Coordinate[] pts2) {
        for (int i2 = 0; i2 < pts1.length; ++i2) {
            Coordinate p1 = pts1[i2];
            Coordinate p2 = pts2[pts1.length - i2 - 1];
            if (p1.compareTo(p2) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate[] copyDeep(Coordinate[] coordinates) {
        Coordinate[] copy = new Coordinate[coordinates.length];
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            copy[i2] = new Coordinate(coordinates[i2]);
        }
        return copy;
    }

    public static void copyDeep(Coordinate[] src, int srcStart, Coordinate[] dest, int destStart, int length2) {
        for (int i2 = 0; i2 < length2; ++i2) {
            dest[destStart + i2] = new Coordinate(src[srcStart + i2]);
        }
    }

    public static Coordinate[] toCoordinateArray(Collection coordList) {
        return coordList.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coord) {
        for (int i2 = 1; i2 < coord.length; ++i2) {
            if (!coord[i2 - 1].equals(coord[i2])) continue;
            return true;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] c) {
        return c.length >= n ? c : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coord) {
        if (!CoordinateArrays.hasRepeatedPoints(coord)) {
            return coord;
        }
        CoordinateList coordList = new CoordinateList(coord, false);
        return coordList.toCoordinateArray();
    }

    public static void reverse(Coordinate[] coord) {
        int last2 = coord.length - 1;
        int mid = last2 / 2;
        for (int i2 = 0; i2 <= mid; ++i2) {
            Coordinate tmp = coord[i2];
            coord[i2] = coord[last2 - i2];
            coord[last2 - i2] = tmp;
        }
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i2 = 0; i2 < coord1.length; ++i2) {
            if (coord1[i2].equals(coord2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Coordinate[] coord1, Coordinate[] coord2, Comparator coordinateComparator) {
        if (coord1 == coord2) {
            return true;
        }
        if (coord1 == null || coord2 == null) {
            return false;
        }
        if (coord1.length != coord2.length) {
            return false;
        }
        for (int i2 = 0; i2 < coord1.length; ++i2) {
            if (coordinateComparator.compare(coord1[i2], coord2[i2]) == 0) continue;
            return false;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinates) {
        Coordinate minCoord = null;
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            if (minCoord != null && minCoord.compareTo(coordinates[i2]) <= 0) continue;
            minCoord = coordinates[i2];
        }
        return minCoord;
    }

    public static void scroll(Coordinate[] coordinates, Coordinate firstCoordinate) {
        int i2 = CoordinateArrays.indexOf(firstCoordinate, coordinates);
        if (i2 < 0) {
            return;
        }
        Coordinate[] newCoordinates = new Coordinate[coordinates.length];
        System.arraycopy(coordinates, i2, newCoordinates, 0, coordinates.length - i2);
        System.arraycopy(coordinates, 0, newCoordinates, coordinates.length - i2, i2);
        System.arraycopy(newCoordinates, 0, coordinates, 0, coordinates.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinates) {
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            if (!coordinate.equals(coordinates[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static Coordinate[] extract(Coordinate[] pts, int start2, int end2) {
        start2 = MathUtil.clamp(start2, 0, pts.length);
        end2 = MathUtil.clamp(end2, -1, pts.length);
        int npts = end2 - start2 + 1;
        if (end2 < 0) {
            npts = 0;
        }
        if (start2 >= pts.length) {
            npts = 0;
        }
        if (end2 < start2) {
            npts = 0;
        }
        Coordinate[] extractPts = new Coordinate[npts];
        if (npts == 0) {
            return extractPts;
        }
        int iPts = 0;
        for (int i2 = start2; i2 <= end2; ++i2) {
            extractPts[iPts++] = pts[i2];
        }
        return extractPts;
    }

    public static class BidirectionalComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int forwardComp = CoordinateArrays.compare(pts1, pts2);
            boolean isEqualRev = CoordinateArrays.isEqualReversed(pts1, pts2);
            if (isEqualRev) {
                return 0;
            }
            return forwardComp;
        }

        public int OLDcompare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            if (pts1.length < pts2.length) {
                return -1;
            }
            if (pts1.length > pts2.length) {
                return 1;
            }
            if (pts1.length == 0) {
                return 0;
            }
            int dir1 = CoordinateArrays.increasingDirection(pts1);
            int dir2 = CoordinateArrays.increasingDirection(pts2);
            int i1 = dir1 > 0 ? 0 : pts1.length - 1;
            int i2 = dir2 > 0 ? 0 : pts1.length - 1;
            for (int i3 = 0; i3 < pts1.length; ++i3) {
                int comparePt = pts1[i1].compareTo(pts2[i2]);
                if (comparePt != 0) {
                    return comparePt;
                }
                i1 += dir1;
                i2 += dir2;
            }
            return 0;
        }
    }

    public static class ForwardComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Coordinate[] pts1 = (Coordinate[])o1;
            Coordinate[] pts2 = (Coordinate[])o2;
            return CoordinateArrays.compare(pts1, pts2);
        }
    }
}

