/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.awt;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;

public class PolygonShape
implements Shape {
    private GeneralPath polygonPath;
    private GeneralPath ringPath;

    public PolygonShape(Coordinate[] shellVertices, Collection holeVerticesCollection) {
        this.polygonPath = this.toPath(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.polygonPath.append(this.toPath(holeVertices), false);
        }
    }

    public PolygonShape() {
    }

    void addToRing(Point2D p2) {
        if (this.ringPath == null) {
            this.ringPath = new GeneralPath(0);
            this.ringPath.moveTo((float)p2.getX(), (float)p2.getY());
        } else {
            this.ringPath.lineTo((float)p2.getX(), (float)p2.getY());
        }
    }

    void endRing() {
        if (this.polygonPath == null) {
            this.polygonPath = this.ringPath;
        } else {
            this.polygonPath.append(this.ringPath, false);
        }
        this.ringPath = null;
    }

    private GeneralPath toPath(Coordinate[] coordinates) {
        GeneralPath path2 = new GeneralPath(0, coordinates.length);
        if (coordinates.length > 0) {
            path2.moveTo((float)coordinates[0].x, (float)coordinates[0].y);
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                path2.lineTo((float)coordinates[i2].x, (float)coordinates[i2].y);
            }
        }
        return path2;
    }

    public Rectangle getBounds() {
        return this.polygonPath.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.polygonPath.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.polygonPath.contains(x, y);
    }

    public boolean contains(Point2D p2) {
        return this.polygonPath.contains(p2);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.polygonPath.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.polygonPath.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.polygonPath.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.polygonPath.contains(r);
    }

    public PathIterator getPathIterator(AffineTransform at2) {
        return this.polygonPath.getPathIterator(at2);
    }

    public PathIterator getPathIterator(AffineTransform at2, double flatness) {
        return this.getPathIterator(at2, flatness);
    }
}

