/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.index.ArrayListVisitor;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.SortedPackedIntervalRTree;
import java.util.List;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private IntervalIndexedGeometry index;

    public IndexedPointInAreaLocator(Geometry g) {
        if (!(g instanceof Polygonal)) {
            throw new IllegalArgumentException("Argument must be Polygonal");
        }
        this.buildIndex(g);
    }

    private void buildIndex(Geometry g) {
        this.index = new IntervalIndexedGeometry(g);
    }

    public int locate(Coordinate p2) {
        RayCrossingCounter rcc = new RayCrossingCounter(p2);
        SegmentVisitor visitor = new SegmentVisitor(rcc);
        this.index.query(p2.y, p2.y, visitor);
        return rcc.getLocation();
    }

    private static class IntervalIndexedGeometry {
        private SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geom) {
            this.init(geom);
        }

        private void init(Geometry geom) {
            List lines2 = LinearComponentExtracter.getLines(geom);
            for (LineString line : lines2) {
                Coordinate[] pts = line.getCoordinates();
                this.addLine(pts);
            }
        }

        private void addLine(Coordinate[] pts) {
            for (int i2 = 1; i2 < pts.length; ++i2) {
                LineSegment seg = new LineSegment(pts[i2 - 1], pts[i2]);
                double min2 = Math.min(seg.p0.y, seg.p1.y);
                double max2 = Math.max(seg.p0.y, seg.p1.y);
                this.index.insert(min2, max2, seg);
            }
        }

        public List query(double min2, double max2) {
            ArrayListVisitor visitor = new ArrayListVisitor();
            this.index.query(min2, max2, visitor);
            return visitor.getItems();
        }

        public void query(double min2, double max2, ItemVisitor visitor) {
            this.index.query(min2, max2, visitor);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter counter) {
            this.counter = counter;
        }

        public void visitItem(Object item) {
            LineSegment seg = (LineSegment)item;
            this.counter.countSegment(seg.getCoordinate(0), seg.getCoordinate(1));
        }
    }
}

