/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public class PointLocator {
    private BoundaryNodeRule boundaryRule = BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE;
    private boolean isIn;
    private int numBoundaries;

    public PointLocator() {
    }

    public PointLocator(BoundaryNodeRule boundaryRule) {
        if (boundaryRule == null) {
            throw new IllegalArgumentException("Rule must be non-null");
        }
        this.boundaryRule = boundaryRule;
    }

    public boolean intersects(Coordinate p2, Geometry geom) {
        return this.locate(p2, geom) != 2;
    }

    public int locate(Coordinate p2, Geometry geom) {
        if (geom.isEmpty()) {
            return 2;
        }
        if (geom instanceof LineString) {
            return this.locate(p2, (LineString)geom);
        }
        if (geom instanceof Polygon) {
            return this.locate(p2, (Polygon)geom);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(p2, geom);
        if (this.boundaryRule.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries > 0 || this.isIn) {
            return 0;
        }
        return 2;
    }

    private void computeLocation(Coordinate p2, Geometry geom) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (geom instanceof Point) {
                                this.updateLocationInfo(this.locate(p2, (Point)geom));
                            }
                            if (!(geom instanceof LineString)) break block4;
                            this.updateLocationInfo(this.locate(p2, (LineString)geom));
                            break block5;
                        }
                        if (!(geom instanceof Polygon)) break block6;
                        this.updateLocationInfo(this.locate(p2, (Polygon)geom));
                        break block5;
                    }
                    if (!(geom instanceof MultiLineString)) break block7;
                    MultiLineString ml = (MultiLineString)geom;
                    for (int i2 = 0; i2 < ml.getNumGeometries(); ++i2) {
                        LineString l = (LineString)ml.getGeometryN(i2);
                        this.updateLocationInfo(this.locate(p2, l));
                    }
                    break block5;
                }
                if (!(geom instanceof MultiPolygon)) break block8;
                MultiPolygon mpoly = (MultiPolygon)geom;
                for (int i3 = 0; i3 < mpoly.getNumGeometries(); ++i3) {
                    Polygon poly = (Polygon)mpoly.getGeometryN(i3);
                    this.updateLocationInfo(this.locate(p2, poly));
                }
                break block5;
            }
            if (!(geom instanceof GeometryCollection)) break block5;
            GeometryCollectionIterator geomi = new GeometryCollectionIterator((GeometryCollection)geom);
            while (geomi.hasNext()) {
                Geometry g2 = (Geometry)geomi.next();
                if (g2 == geom) continue;
                this.computeLocation(p2, g2);
            }
        }
    }

    private void updateLocationInfo(int loc) {
        if (loc == 0) {
            this.isIn = true;
        }
        if (loc == 1) {
            ++this.numBoundaries;
        }
    }

    private int locate(Coordinate p2, Point pt) {
        Coordinate ptCoord = pt.getCoordinate();
        if (ptCoord.equals2D(p2)) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate p2, LineString l) {
        if (!l.getEnvelopeInternal().intersects(p2)) {
            return 2;
        }
        Coordinate[] pt = l.getCoordinates();
        if (!l.isClosed() && (p2.equals(pt[0]) || p2.equals(pt[pt.length - 1]))) {
            return 1;
        }
        if (CGAlgorithms.isOnLine(p2, pt)) {
            return 0;
        }
        return 2;
    }

    private int locateInPolygonRing(Coordinate p2, LinearRing ring) {
        if (!ring.getEnvelopeInternal().intersects(p2)) {
            return 2;
        }
        return CGAlgorithms.locatePointInRing(p2, ring.getCoordinates());
    }

    private int locate(Coordinate p2, Polygon poly) {
        if (poly.isEmpty()) {
            return 2;
        }
        LinearRing shell = (LinearRing)poly.getExteriorRing();
        int shellLoc = this.locateInPolygonRing(p2, shell);
        if (shellLoc == 2) {
            return 2;
        }
        if (shellLoc == 1) {
            return 1;
        }
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            LinearRing hole = (LinearRing)poly.getInteriorRingN(i2);
            int holeLoc = this.locateInPolygonRing(p2, hole);
            if (holeLoc == 0) {
                return 2;
            }
            if (holeLoc != 1) continue;
            return 1;
        }
        return 0;
    }
}

