/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;

public class CGAlgorithms {
    public static final int CLOCKWISE = -1;
    public static final int RIGHT = -1;
    public static final int COUNTERCLOCKWISE = 1;
    public static final int LEFT = 1;
    public static final int COLLINEAR = 0;
    public static final int STRAIGHT = 0;

    public static int orientationIndex(Coordinate p1, Coordinate p2, Coordinate q) {
        double dx1 = p2.x - p1.x;
        double dy1 = p2.y - p1.y;
        double dx2 = q.x - p2.x;
        double dy2 = q.y - p2.y;
        return RobustDeterminant.signOfDet2x2(dx1, dy1, dx2, dy2);
    }

    public static boolean isPointInRing(Coordinate p2, Coordinate[] ring) {
        return CGAlgorithms.locatePointInRing(p2, ring) != 2;
    }

    public static int locatePointInRing(Coordinate p2, Coordinate[] ring) {
        return RayCrossingCounter.locatePointInRing(p2, ring);
    }

    public static boolean isOnLine(Coordinate p2, Coordinate[] pt) {
        RobustLineIntersector lineIntersector = new RobustLineIntersector();
        for (int i2 = 1; i2 < pt.length; ++i2) {
            Coordinate p0 = pt[i2 - 1];
            Coordinate p1 = pt[i2];
            ((LineIntersector)lineIntersector).computeIntersection(p2, p0, p1);
            if (!lineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCCW(Coordinate[] ring) {
        int nPts = ring.length - 1;
        if (nPts < 3) {
            throw new IllegalArgumentException("Ring has fewer than 3 points, so orientation cannot be determined");
        }
        Coordinate hiPt = ring[0];
        int hiIndex = 0;
        for (int i2 = 1; i2 <= nPts; ++i2) {
            Coordinate p2 = ring[i2];
            if (!(p2.y > hiPt.y)) continue;
            hiPt = p2;
            hiIndex = i2;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (ring[iPrev].equals2D(hiPt) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (ring[iNext = (iNext + 1) % nPts].equals2D(hiPt) && iNext != hiIndex) {
        }
        Coordinate prev = ring[iPrev];
        Coordinate next = ring[iNext];
        if (prev.equals2D(hiPt) || next.equals2D(hiPt) || prev.equals2D(next)) {
            return false;
        }
        int disc = CGAlgorithms.computeOrientation(prev, hiPt, next);
        boolean isCCW = false;
        isCCW = disc == 0 ? prev.x > next.x : disc > 0;
        return isCCW;
    }

    public static int computeOrientation(Coordinate p1, Coordinate p2, Coordinate q) {
        return CGAlgorithms.orientationIndex(p1, p2, q);
    }

    public static double distancePointLine(Coordinate p2, Coordinate A, Coordinate B) {
        if (A.x == B.x && A.y == B.y) {
            return p2.distance(A);
        }
        double r = ((p2.x - A.x) * (B.x - A.x) + (p2.y - A.y) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        if (r <= 0.0) {
            return p2.distance(A);
        }
        if (r >= 1.0) {
            return p2.distance(B);
        }
        double s2 = ((A.y - p2.y) * (B.x - A.x) - (A.x - p2.x) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        return Math.abs(s2) * Math.sqrt((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
    }

    public static double distancePointLinePerpendicular(Coordinate p2, Coordinate A, Coordinate B) {
        double s2 = ((A.y - p2.y) * (B.x - A.x) - (A.x - p2.x) * (B.y - A.y)) / ((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
        return Math.abs(s2) * Math.sqrt((B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y));
    }

    public static double distancePointLine(Coordinate p2, Coordinate[] line) {
        if (line.length == 0) {
            throw new IllegalArgumentException("Line array must contain at least one vertex");
        }
        double minDistance = p2.distance(line[0]);
        for (int i2 = 0; i2 < line.length - 1; ++i2) {
            double dist = CGAlgorithms.distancePointLine(p2, line[i2], line[i2 + 1]);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
        }
        return minDistance;
    }

    public static double distanceLineLine(Coordinate A, Coordinate B, Coordinate C2, Coordinate D) {
        if (A.equals(B)) {
            return CGAlgorithms.distancePointLine(A, C2, D);
        }
        if (C2.equals(D)) {
            return CGAlgorithms.distancePointLine(D, A, B);
        }
        double r_top = (A.y - C2.y) * (D.x - C2.x) - (A.x - C2.x) * (D.y - C2.y);
        double r_bot = (B.x - A.x) * (D.y - C2.y) - (B.y - A.y) * (D.x - C2.x);
        double s_top = (A.y - C2.y) * (B.x - A.x) - (A.x - C2.x) * (B.y - A.y);
        double s_bot = (B.x - A.x) * (D.y - C2.y) - (B.y - A.y) * (D.x - C2.x);
        if (r_bot == 0.0 || s_bot == 0.0) {
            return Math.min(CGAlgorithms.distancePointLine(A, C2, D), Math.min(CGAlgorithms.distancePointLine(B, C2, D), Math.min(CGAlgorithms.distancePointLine(C2, A, B), CGAlgorithms.distancePointLine(D, A, B))));
        }
        double s2 = s_top / s_bot;
        double r = r_top / r_bot;
        if (r < 0.0 || r > 1.0 || s2 < 0.0 || s2 > 1.0) {
            return Math.min(CGAlgorithms.distancePointLine(A, C2, D), Math.min(CGAlgorithms.distancePointLine(B, C2, D), Math.min(CGAlgorithms.distancePointLine(C2, A, B), CGAlgorithms.distancePointLine(D, A, B))));
        }
        return 0.0;
    }

    public static double signedArea(Coordinate[] ring) {
        if (ring.length < 3) {
            return 0.0;
        }
        double sum2 = 0.0;
        for (int i2 = 0; i2 < ring.length - 1; ++i2) {
            double bx = ring[i2].x;
            double by = ring[i2].y;
            double cx = ring[i2 + 1].x;
            double cy = ring[i2 + 1].y;
            sum2 += (bx + cx) * (cy - by);
        }
        return -sum2 / 2.0;
    }

    public static double signedArea(CoordinateSequence ring) {
        int n = ring.size();
        if (n < 3) {
            return 0.0;
        }
        double sum2 = 0.0;
        Coordinate p2 = new Coordinate();
        ring.getCoordinate(0, p2);
        double bx = p2.x;
        double by = p2.y;
        for (int i2 = 1; i2 < n; ++i2) {
            ring.getCoordinate(i2, p2);
            double cx = p2.x;
            double cy = p2.y;
            sum2 += (bx + cx) * (cy - by);
            bx = cx;
            by = cy;
        }
        return -sum2 / 2.0;
    }

    public static double length(CoordinateSequence pts) {
        int n = pts.size();
        if (n <= 1) {
            return 0.0;
        }
        double len = 0.0;
        Coordinate p2 = new Coordinate();
        pts.getCoordinate(0, p2);
        double x0 = p2.x;
        double y0 = p2.y;
        for (int i2 = 1; i2 < n; ++i2) {
            pts.getCoordinate(i2, p2);
            double x1 = p2.x;
            double y1 = p2.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            len += Math.sqrt(dx * dx + dy * dy);
            x0 = x1;
            y0 = y1;
        }
        return len;
    }
}

