/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReceiver;
import com.thaiopensource.validate.auto.ReparseException;
import com.thaiopensource.validate.auto.Rewindable;
import com.thaiopensource.validate.auto.RewindableInputStream;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AutoSchemaReader
implements SchemaReader {
    private final SchemaReceiverFactory srf;

    public AutoSchemaReader() {
        this(new SchemaReceiverLoader());
    }

    public AutoSchemaReader(SchemaReceiverFactory schemaReceiverFactory) {
        this.srf = schemaReceiverFactory == null ? new SchemaReceiverLoader() : schemaReceiverFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema createSchema(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        Object object;
        Object object2;
        if (SchemaReceiverFactory.PROPERTY.get(propertyMap) != this.srf) {
            object2 = new PropertyMapBuilder(propertyMap);
            SchemaReceiverFactory.PROPERTY.put((PropertyMapBuilder)object2, this.srf);
            propertyMap = ((PropertyMapBuilder)object2).toPropertyMap();
        }
        object2 = new InputSource();
        ((InputSource)object2).setSystemId(inputSource.getSystemId());
        ((InputSource)object2).setPublicId(inputSource.getPublicId());
        ((InputSource)object2).setEncoding(inputSource.getEncoding());
        if (inputSource.getCharacterStream() != null) {
            throw new IllegalArgumentException("character stream input sources not supported for auto-detection");
        }
        Object object3 = inputSource.getByteStream();
        if (object3 == null) {
            object = inputSource.getSystemId();
            if (object == null) {
                throw new IllegalArgumentException("null systemId and null byteStream");
            }
            object3 = new URL((String)object).openStream();
        }
        object = new RewindableInputStream((InputStream)object3);
        inputSource.setByteStream((InputStream)object);
        ((InputSource)object2).setByteStream((InputStream)object);
        Object object4 = object;
        object3 = new AutoSchemaReceiver(propertyMap, (Rewindable)object4);
        object = ValidateProperty.XML_READER_CREATOR.get(propertyMap);
        XMLReader xMLReader = object.createXMLReader();
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        if (errorHandler != null) {
            xMLReader.setErrorHandler(errorHandler);
        }
        SchemaFuture schemaFuture = object3.installHandlers(xMLReader);
        try {
            xMLReader.parse(inputSource);
            Schema schema = schemaFuture.getSchema();
            object4.willNotRewind();
            return schema;
        }
        catch (ReparseException reparseException) {
            try {
                object4.rewind();
                object4.willNotRewind();
                Schema schema = reparseException.reparse((InputSource)object2);
                object4.willNotRewind();
                return schema;
            }
            catch (Throwable throwable) {
                try {
                    object4.willNotRewind();
                    throw throwable;
                }
                catch (SAXException sAXException) {
                    Exception exception2 = sAXException.getException();
                    if (exception2 instanceof RuntimeException) {
                        schemaFuture.unwrapException((RuntimeException)exception2);
                    }
                    throw sAXException;
                }
                catch (RuntimeException runtimeException) {
                    throw schemaFuture.unwrapException(runtimeException);
                }
            }
        }
    }

    public Option getOption(String string2) {
        return this.srf.getOption(string2);
    }
}

