/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.xml.sax.SAXException;

class TestDriver {
    private ValidationDriver driver;
    private ErrorHandlerImpl eh;
    private Localizer localizer = new Localizer(class$com$thaiopensource$relaxng$util$TestDriver == null ? (class$com$thaiopensource$relaxng$util$TestDriver = TestDriver.class$("com.thaiopensource.relaxng.util.TestDriver")) : class$com$thaiopensource$relaxng$util$TestDriver);
    private int nTests = 0;
    private static final String CORRECT_SCHEMA_NAME = "c.rng";
    private static final String INCORRECT_SCHEMA_NAME = "i.rng";
    private static final String VALID_INSTANCE_SUFFIX = ".v.xml";
    private static final String INVALID_INSTANCE_SUFFIX = ".i.xml";
    static /* synthetic */ Class class$com$thaiopensource$relaxng$util$TestDriver;

    TestDriver() {
    }

    public static void main(String[] stringArray) throws IOException {
        System.exit(new TestDriver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        this.eh = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("i", stringArray);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        RngProperty.DATATYPE_LIBRARY_FACTORY.put(propertyMapBuilder, new DatatypeLibraryLoader());
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            this.eh.print(this.localizer.message("invalid_option", optionParser.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            this.eh.print(this.localizer.message("option_missing_argument", optionParser.getOptionCharString()));
            return 2;
        }
        stringArray = optionParser.getRemainingArgs();
        this.eh = new ErrorHandlerImpl(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(stringArray[0]))));
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.eh);
        this.driver = new ValidationDriver(propertyMapBuilder.toPropertyMap());
        int n = 0;
        for (int j = 1; j < stringArray.length; ++j) {
            int n2 = this.runTestSuite(new File(stringArray[j]));
            if (n2 <= n) continue;
            n = n2;
        }
        System.err.println("Number of tests: " + this.nTests);
        System.err.println("Elapsed time: " + (System.currentTimeMillis() - l));
        this.eh.close();
        return n;
    }

    public int runTestSuite(File file2) throws IOException {
        int n = 0;
        String[] stringArray = file2.list();
        for (int j = 0; j < stringArray.length; ++j) {
            int n2;
            File file3 = new File(file2, stringArray[j]);
            if (!file3.isDirectory() || (n2 = this.runTestCase(file3)) <= n) continue;
            n = n2;
        }
        return n;
    }

    private int runTestCase(File file2) throws IOException {
        File file3 = new File(file2, INCORRECT_SCHEMA_NAME);
        if (file3.exists()) {
            if (this.loadSchema(file3)) {
                TestDriver.failed(file3);
                return 1;
            }
            return 0;
        }
        file3 = new File(file2, CORRECT_SCHEMA_NAME);
        if (!file3.exists()) {
            return 0;
        }
        if (!this.loadSchema(file3)) {
            TestDriver.failed(file3);
            return 1;
        }
        String[] stringArray = file2.list();
        int n = 0;
        for (int j = 0; j < stringArray.length; ++j) {
            if (stringArray[j].endsWith(VALID_INSTANCE_SUFFIX)) {
                file3 = new File(file2, stringArray[j]);
                if (this.validateInstance(file3)) continue;
                TestDriver.failed(file3);
                n = 1;
                continue;
            }
            if (!stringArray[j].endsWith(INVALID_INSTANCE_SUFFIX) || !this.validateInstance(file3 = new File(file2, stringArray[j]))) continue;
            TestDriver.failed(file3);
            n = 1;
        }
        return n;
    }

    private static void failed(File file2) {
        System.err.println("Failed: " + file2.toString());
    }

    private boolean loadSchema(File file2) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.loadSchema(ValidationDriver.fileInputSource(file2))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }

    private boolean validateInstance(File file2) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.validate(ValidationDriver.fileInputSource(file2))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

