/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.compact.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string2) {
        super(string2);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int j = 0; j < this.expectedTokenSequences.length; ++j) {
            if (n < this.expectedTokenSequences[j].length) {
                n = this.expectedTokenSequences[j].length;
            }
            for (int k = 0; k < this.expectedTokenSequences[j].length; ++k) {
                stringBuffer.append(this.tokenImage[this.expectedTokenSequences[j][k]]).append(' ');
            }
            if (this.expectedTokenSequences[j][this.expectedTokenSequences[j].length - 1] != 0) {
                stringBuffer.append("...");
            }
            stringBuffer.append(this.eol).append("    ");
        }
        String string2 = "Encountered \"";
        Token token = this.currentToken.next;
        for (int j = 0; j < n; ++j) {
            if (j != 0) {
                string2 = string2 + " ";
            }
            if (token.kind == 0) {
                string2 = string2 + this.tokenImage[0];
                break;
            }
            string2 = string2 + " " + this.tokenImage[token.kind];
            string2 = string2 + " \"";
            string2 = string2 + this.add_escapes(token.image);
            string2 = string2 + " \"";
            token = token.next;
        }
        string2 = string2 + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        string2 = string2 + "." + this.eol;
        string2 = this.expectedTokenSequences.length == 1 ? string2 + "Was expecting:" + this.eol + "    " : string2 + "Was expecting one of:" + this.eol + "    ";
        string2 = string2 + stringBuffer.toString();
        return string2;
    }

    protected String add_escapes(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int j = 0; j < string2.length(); ++j) {
            switch (string2.charAt(j)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string2.charAt(j);
                    if (c < ' ' || c > '~') {
                        String string3 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

