/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.compact.EOFException;
import com.thaiopensource.relaxng.parse.compact.EscapeSyntaxException;
import com.thaiopensource.util.Utf16;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class JavaCharStream {
    public static final boolean staticFlag = false;
    public int bufpos = -1;
    int bufsize;
    int available;
    int tokenBegin;
    private int[] bufline;
    private int[] bufcolumn;
    private int column = 0;
    private int line = 1;
    private Reader inputStream;
    private boolean closed = false;
    private boolean prevCharIsLF = false;
    private char[] nextCharBuf;
    private char[] buffer;
    private int maxNextCharInd = 0;
    private int nextCharInd = -1;
    private int inBuf = 0;
    private int tabSize = 8;
    private final char NEWLINE_MARKER = '\u0000';
    private static final char BOM = '\ufeff';

    static final int hexval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    protected void setTabSize(int n) {
        this.tabSize = n;
    }

    protected int getTabSize(int n) {
        return this.tabSize;
    }

    private final void ExpandBuff(boolean bl) {
        char[] cArray = new char[this.bufsize + 2048];
        int[] nArray = new int[this.bufsize + 2048];
        int[] nArray2 = new int[this.bufsize + 2048];
        if (bl) {
            System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
            System.arraycopy(this.buffer, 0, cArray, this.bufsize - this.tokenBegin, this.bufpos);
            this.buffer = cArray;
            System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
            System.arraycopy(this.bufline, 0, nArray, this.bufsize - this.tokenBegin, this.bufpos);
            this.bufline = nArray;
            System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
            System.arraycopy(this.bufcolumn, 0, nArray2, this.bufsize - this.tokenBegin, this.bufpos);
            this.bufcolumn = nArray2;
            this.bufpos += this.bufsize - this.tokenBegin;
        } else {
            System.arraycopy(this.buffer, this.tokenBegin, cArray, 0, this.bufsize - this.tokenBegin);
            this.buffer = cArray;
            System.arraycopy(this.bufline, this.tokenBegin, nArray, 0, this.bufsize - this.tokenBegin);
            this.bufline = nArray;
            System.arraycopy(this.bufcolumn, this.tokenBegin, nArray2, 0, this.bufsize - this.tokenBegin);
            this.bufcolumn = nArray2;
            this.bufpos -= this.tokenBegin;
        }
        this.available = this.bufsize += 2048;
        this.tokenBegin = 0;
    }

    private final void FillBuff() throws EOFException {
        if (this.maxNextCharInd == 4096) {
            this.nextCharInd = 0;
            this.maxNextCharInd = 0;
        }
        if (this.closed) {
            throw new EOFException();
        }
        try {
            int n = this.inputStream.read(this.nextCharBuf, this.maxNextCharInd, 4096 - this.maxNextCharInd);
            if (n == -1) {
                this.closed = true;
                this.inputStream.close();
                throw new EOFException();
            }
            this.maxNextCharInd += n;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private final char ReadChar() throws EOFException {
        if (++this.nextCharInd >= this.maxNextCharInd) {
            this.FillBuff();
        }
        return this.nextCharBuf[this.nextCharInd];
    }

    private final char PeekChar() throws EOFException {
        char c = this.ReadChar();
        --this.nextCharInd;
        return c;
    }

    public final char BeginToken() throws EOFException {
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.tokenBegin = this.bufpos;
            return this.buffer[this.bufpos];
        }
        this.tokenBegin = 0;
        this.bufpos = -1;
        return this.readChar();
    }

    private final void AdjustBuffSize() {
        if (this.available == this.bufsize) {
            if (this.tokenBegin > 2048) {
                this.bufpos = 0;
                this.available = this.tokenBegin;
            } else {
                this.ExpandBuff(false);
            }
        } else if (this.available > this.tokenBegin) {
            this.available = this.bufsize;
        } else if (this.tokenBegin - this.available < 2048) {
            this.ExpandBuff(true);
        } else {
            this.available = this.tokenBegin;
        }
    }

    private final void UpdateLineColumn(char c) {
        ++this.column;
        if (this.prevCharIsLF) {
            this.prevCharIsLF = false;
            this.column = 1;
            ++this.line;
        }
        switch (c) {
            case '\u0000': {
                this.prevCharIsLF = true;
                break;
            }
            case '\t': {
                --this.column;
                this.column += this.tabSize - this.column % this.tabSize;
                break;
            }
        }
        this.bufline[this.bufpos] = this.line;
        this.bufcolumn[this.bufpos] = this.column;
    }

    public final char readChar() throws EOFException {
        char c;
        if (this.inBuf > 0) {
            --this.inBuf;
            if (++this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            return this.buffer[this.bufpos];
        }
        try {
            c = this.ReadChar();
            switch (c) {
                case '\r': {
                    c = '\u0000';
                    try {
                        if (this.PeekChar() == '\n') {
                            this.ReadChar();
                        }
                    }
                    catch (EOFException eOFException) {}
                    break;
                }
                case '\n': {
                    c = '\u0000';
                    break;
                }
                case '\t': {
                    break;
                }
                default: {
                    if (c >= ' ') {
                        if (!Utf16.isSurrogate(c)) break;
                        if (Utf16.isSurrogate2(c)) {
                            throw new EscapeSyntaxException("illegal_surrogate_pair", this.line, this.column + 1);
                        }
                        if (++this.bufpos == this.available) {
                            this.AdjustBuffSize();
                        }
                        this.buffer[this.bufpos] = c;
                        try {
                            c = this.ReadChar();
                        }
                        catch (EOFException eOFException) {
                            throw new EscapeSyntaxException("illegal_surrogate_pair", this.line, this.column + 1);
                        }
                        if (!Utf16.isSurrogate2(c)) {
                            throw new EscapeSyntaxException("illegal_surrogate_pair", this.line, this.column + 2);
                        }
                        break;
                    }
                }
                case '\ufffe': 
                case '\uffff': {
                    throw new EscapeSyntaxException("illegal_char_code", this.line, this.column + 1);
                }
            }
        }
        catch (EOFException eOFException) {
            if (this.bufpos == -1) {
                if (++this.bufpos == this.available) {
                    this.AdjustBuffSize();
                }
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            throw eOFException;
        }
        if (++this.bufpos == this.available) {
            this.AdjustBuffSize();
        }
        this.buffer[this.bufpos] = c;
        this.UpdateLineColumn(c);
        try {
            if (c != '\\' || this.PeekChar() != 'x') {
                return c;
            }
        }
        catch (EOFException eOFException) {
            return c;
        }
        int n = 1;
        while (true) {
            this.ReadChar();
            if (++this.bufpos == this.available) {
                this.AdjustBuffSize();
            }
            this.buffer[this.bufpos] = 120;
            this.UpdateLineColumn('x');
            try {
                c = this.PeekChar();
            }
            catch (EOFException eOFException) {
                this.backup(n);
                return '\\';
            }
            if (c == '{') {
                this.ReadChar();
                ++this.column;
                this.bufpos -= n;
                if (this.bufpos >= 0) break;
                this.bufpos += this.bufsize;
                break;
            }
            if (c != 'x') {
                this.backup(n);
                return '\\';
            }
            ++n;
        }
        try {
            int n2;
            int n3 = JavaCharStream.hexval(this.ReadChar());
            ++this.column;
            if (n3 < 0) {
                throw new EscapeSyntaxException("illegal_hex_digit", this.line, this.column);
            }
            while ((c = this.ReadChar()) != '}') {
                ++this.column;
                n2 = JavaCharStream.hexval(c);
                if (n2 < 0) {
                    throw new EscapeSyntaxException("illegal_hex_digit", this.line, this.column);
                }
                n3 <<= 4;
                if ((n3 |= n2) < 0x110000) continue;
                throw new EscapeSyntaxException("char_code_too_big", this.line, this.column);
            }
            ++this.column;
            if (n3 <= 65535) {
                c = (char)n3;
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        if (c >= ' ' && !Utf16.isSurrogate(c)) break;
                    }
                    case '\ufffe': 
                    case '\uffff': {
                        throw new EscapeSyntaxException("illegal_char_code_ref", this.line, this.column);
                    }
                }
                this.buffer[this.bufpos] = c;
                return c;
            }
            this.buffer[this.bufpos] = c = Utf16.surrogate1(n3);
            n2 = this.bufpos++;
            if (this.bufpos == this.bufsize) {
                this.bufpos = 0;
            }
            this.buffer[this.bufpos] = Utf16.surrogate2(n3);
            this.bufline[this.bufpos] = this.bufline[n2];
            this.bufcolumn[this.bufpos] = this.bufcolumn[n2];
            this.backup(1);
            return c;
        }
        catch (EOFException eOFException) {
            throw new EscapeSyntaxException("incomplete_escape", this.line, this.column);
        }
    }

    public final int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getLine() {
        return this.bufline[this.bufpos];
    }

    public final int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public final int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public final int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public final void backup(int n) {
        this.inBuf += n;
        if ((this.bufpos -= n) < 0) {
            this.bufpos += this.bufsize;
        }
    }

    public JavaCharStream(Reader reader, int n, int n2, int n3) {
        this.inputStream = reader;
        this.line = n;
        this.column = n2 - 1;
        this.available = this.bufsize = n3;
        this.buffer = new char[n3];
        this.bufline = new int[n3];
        this.bufcolumn = new int[n3];
        this.nextCharBuf = new char[4096];
        this.skipBOM();
    }

    public JavaCharStream(Reader reader, int n, int n2) {
        this(reader, n, n2, 4096);
    }

    public JavaCharStream(Reader reader) {
        this(reader, 1, 1, 4096);
    }

    public void ReInit(Reader reader, int n, int n2, int n3) {
        this.inputStream = reader;
        this.closed = false;
        this.line = n;
        this.column = n2 - 1;
        if (this.buffer == null || n3 != this.buffer.length) {
            this.available = this.bufsize = n3;
            this.buffer = new char[n3];
            this.bufline = new int[n3];
            this.bufcolumn = new int[n3];
            this.nextCharBuf = new char[4096];
        }
        this.prevCharIsLF = false;
        this.maxNextCharInd = 0;
        this.inBuf = 0;
        this.tokenBegin = 0;
        this.bufpos = -1;
        this.nextCharInd = -1;
        this.skipBOM();
    }

    public void ReInit(Reader reader, int n, int n2) {
        this.ReInit(reader, n, n2, 4096);
    }

    public void ReInit(Reader reader) {
        this.ReInit(reader, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string2, int n, int n2, int n3) throws UnsupportedEncodingException {
        this(string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2), n, n2, n3);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2, int n3) {
        this(new InputStreamReader(inputStream), n, n2, n3);
    }

    public JavaCharStream(InputStream inputStream, String string2, int n, int n2) throws UnsupportedEncodingException {
        this(inputStream, string2, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, int n, int n2) {
        this(inputStream, n, n2, 4096);
    }

    public JavaCharStream(InputStream inputStream, String string2) throws UnsupportedEncodingException {
        this(inputStream, string2, 1, 1, 4096);
    }

    public JavaCharStream(InputStream inputStream) {
        this(inputStream, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream, String string2, int n, int n2, int n3) throws UnsupportedEncodingException {
        this.ReInit(string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, int n, int n2, int n3) {
        this.ReInit(new InputStreamReader(inputStream), n, n2, n3);
    }

    public void ReInit(InputStream inputStream, String string2, int n, int n2) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string2, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, int n, int n2) {
        this.ReInit(inputStream, n, n2, 4096);
    }

    public void ReInit(InputStream inputStream, String string2) throws UnsupportedEncodingException {
        this.ReInit(inputStream, string2, 1, 1, 4096);
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, 1, 1, 4096);
    }

    private void skipBOM() {
        try {
            if (this.PeekChar() == '\ufeff') {
                this.ReadChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public final String GetImage() {
        if (this.bufpos >= this.tokenBegin) {
            return new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1);
        }
        return new String(this.buffer, this.tokenBegin, this.bufsize - this.tokenBegin) + new String(this.buffer, 0, this.bufpos + 1);
    }

    public final char[] GetSuffix(int n) {
        char[] cArray = new char[n];
        if (this.bufpos + 1 >= n) {
            System.arraycopy(this.buffer, this.bufpos - n + 1, cArray, 0, n);
        } else {
            System.arraycopy(this.buffer, this.bufsize - (n - this.bufpos - 1), cArray, 0, n - this.bufpos - 1);
            System.arraycopy(this.buffer, 0, cArray, n - this.bufpos - 1, this.bufpos + 1);
        }
        return cArray;
    }

    public void Done() {
        this.nextCharBuf = null;
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }

    public void adjustBeginLineColumn(int n, int n2) {
        int n3;
        int n4 = this.tokenBegin;
        int n5 = this.bufpos >= this.tokenBegin ? this.bufpos - this.tokenBegin + this.inBuf + 1 : this.bufsize - this.tokenBegin + this.bufpos + 1 + this.inBuf;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n5 && this.bufline[n6 = n4 % this.bufsize] == this.bufline[n7 = ++n4 % this.bufsize]; ++n3) {
            this.bufline[n6] = n;
            n8 = n9 + this.bufcolumn[n7] - this.bufcolumn[n6];
            this.bufcolumn[n6] = n2 + n9;
            n9 = n8;
        }
        if (n3 < n5) {
            this.bufline[n6] = n++;
            this.bufcolumn[n6] = n2 + n9;
            while (n3++ < n5) {
                n6 = n4 % this.bufsize;
                if (this.bufline[n6] != this.bufline[++n4 % this.bufsize]) {
                    this.bufline[n6] = n++;
                    continue;
                }
                this.bufline[n6] = n;
            }
        }
        this.line = this.bufline[n6];
        this.column = this.bufcolumn[n6];
    }
}

